/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.methodhandles.MethodHandlesSupported;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_LambdaForm;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MemberName;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives;
import com.oracle.svm.methodhandles.Target_java_lang_invoke_MethodHandleNatives_Constants;
import com.oracle.svm.reflect.helpers.InvokeSpecialReflectionProxy;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Method;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_MethodAccessor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

@TargetClass(className="java.lang.invoke.MethodHandle", onlyWith={MethodHandlesSupported.class})
final class Target_java_lang_invoke_MethodHandle {
    @Alias
    private MethodType type;

    Target_java_lang_invoke_MethodHandle() {
    }

    @Alias
    native Target_java_lang_invoke_MemberName internalMemberName();

    @Alias
    native Target_java_lang_invoke_LambdaForm internalForm();

    @Substitute(polymorphicSignature=true)
    Object invokeBasic(Object ... args) throws Throwable {
        Target_java_lang_invoke_MemberName memberName = this.internalMemberName();
        if (memberName != null) {
            Object srcWrapper;
            Wrapper destWrapper;
            if (memberName.reflectAccess == null && memberName.intrinsic == null) {
                Target_java_lang_invoke_MethodHandleNatives.resolve(memberName, null, false);
            }
            if (memberName.intrinsic != null) {
                assert (memberName.reflectAccess == null);
                return memberName.intrinsic.execute(args);
            }
            if (memberName.isField()) {
                Target_java_lang_reflect_AccessibleObject executable = SubstrateUtil.cast(memberName.reflectAccess, Target_java_lang_reflect_AccessibleObject.class);
                boolean oldOverride = executable.override;
                executable.override = true;
                try {
                    Field field = (Field)memberName.reflectAccess;
                    byte refKind = memberName.getReferenceKind();
                    if (Modifier.isStatic(field.getModifiers())) {
                        if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getStatic) {
                            assert (args == null || args.length == 0);
                            Object object = field.get(null);
                            return object;
                        }
                        if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_putStatic) {
                            assert (args.length == 1);
                            Object value = args[0];
                            field.set(null, value);
                            Object var8_21 = null;
                            return var8_21;
                        }
                        throw VMError.shouldNotReachHere("Wrong reference kind for static field access: " + memberName.getReferenceKind());
                    }
                    if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_getField) {
                        assert (args.length == 1);
                        Object receiver = args[0];
                        Object object = field.get(receiver);
                        return object;
                    }
                    if (refKind == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_putField) {
                        assert (args.length == 2);
                        Object receiver = args[0];
                        Object value = args[1];
                        field.set(receiver, value);
                        Object var9_26 = null;
                        return var9_26;
                    }
                    throw VMError.shouldNotReachHere("Wrong reference kind for instance field access: " + memberName.getReferenceKind());
                }
                finally {
                    executable.override = oldOverride;
                }
            }
            assert (args.length == this.type.parameterCount());
            for (int i = 0; i < args.length; ++i) {
                TypeDescriptor.OfField expectedParamType = this.type.parameterType(i);
                if (!((Class)expectedParamType).isPrimitive() || (destWrapper = Wrapper.forPrimitiveType(expectedParamType)) == (srcWrapper = Wrapper.forWrapperType(args[i].getClass()))) continue;
                Target_java_lang_invoke_MethodHandle typeConverter = SubstrateUtil.cast(ValueConversions.convertPrimitive(srcWrapper, destWrapper), Target_java_lang_invoke_MethodHandle.class);
                args[i] = typeConverter.invokeBasic(args[i]);
            }
            Target_java_lang_reflect_AccessibleObject executable = SubstrateUtil.cast(memberName.reflectAccess, Target_java_lang_reflect_AccessibleObject.class);
            boolean oldOverride = executable.override;
            executable.override = true;
            try {
                if (memberName.isConstructor()) {
                    destWrapper = ((Constructor)memberName.reflectAccess).newInstance(args);
                    return destWrapper;
                }
                Method method = (Method)memberName.reflectAccess;
                if (Modifier.isStatic(method.getModifiers())) {
                    srcWrapper = method.invoke(null, args);
                    return srcWrapper;
                }
                Object receiver = args[0];
                Object[] invokeArgs = Arrays.copyOfRange(args, 1, args.length);
                if (memberName.getReferenceKind() == Target_java_lang_invoke_MethodHandleNatives_Constants.REF_invokeSpecial) {
                    Target_jdk_internal_reflect_MethodAccessor accessor = SubstrateUtil.cast(method, Target_java_lang_reflect_Method.class).acquireMethodAccessor();
                    Object object = SubstrateUtil.cast(accessor, InvokeSpecialReflectionProxy.class).invokeSpecial(receiver, invokeArgs);
                    return object;
                }
                Object object = method.invoke(receiver, invokeArgs);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                executable.override = oldOverride;
            }
        }
        Target_java_lang_invoke_LambdaForm form = this.internalForm();
        Object[] interpreterArguments = new Object[args.length + 1];
        interpreterArguments[0] = this;
        System.arraycopy(args, 0, interpreterArguments, 1, args.length);
        return form.interpretWithArguments(interpreterArguments);
    }

    @Substitute(polymorphicSignature=true)
    Object invoke(Object ... args) throws Throwable {
        MethodHandle self = SubstrateUtil.cast(this, MethodHandle.class);
        return self.asType(self.type()).invokeExact(args);
    }

    @Substitute(polymorphicSignature=true)
    Object invokeExact(Object ... args) throws Throwable {
        return this.invokeBasic(args);
    }
}

