/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.phases.ExperimentalNativeImageInlineDuringParsingPlugin;
import com.oracle.svm.hosted.phases.TrivialMethodDetectorBailoutException;
import com.oracle.svm.hosted.phases.TrivialMethodDetectorGraphBuilderPhase;
import com.oracle.svm.hosted.phases.TrivialMethodDetectorParameterPlugin;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.util.Providers;

class TrivialMethodDetector {
    private final HostedProviders providers;
    private final GraphBuilderConfiguration prototypeGraphBuilderConfig;
    private final OptionValues options;
    private final DebugContext debug;

    TrivialMethodDetector(HostedProviders providers, GraphBuilderConfiguration originalGraphBuilderConfig, OptionValues options, DebugContext debug) {
        this.debug = debug;
        this.prototypeGraphBuilderConfig = TrivialMethodDetector.makePrototypeGraphBuilderConfig(originalGraphBuilderConfig);
        this.options = options;
        this.providers = providers;
    }

    private static GraphBuilderConfiguration makePrototypeGraphBuilderConfig(GraphBuilderConfiguration originalGraphBuilderConfig) {
        GraphBuilderConfiguration result = originalGraphBuilderConfig.copy();
        result.getPlugins().clearInlineInvokePlugins();
        for (InlineInvokePlugin inlineInvokePlugin : originalGraphBuilderConfig.getPlugins().getInlineInvokePlugins()) {
            if (inlineInvokePlugin instanceof ExperimentalNativeImageInlineDuringParsingPlugin) continue;
            result.getPlugins().appendInlineInvokePlugin(inlineInvokePlugin);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult analyzeMethod(ExperimentalNativeImageInlineDuringParsingPlugin.CallSite callSite, AnalysisMethod method, ValueNode[] args) {
        if (!method.hasBytecodes()) {
            return ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult.ANALYSIS_TOO_COMPLICATED;
        }
        if (this.providers.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)method) != null) {
            return ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult.ANALYSIS_TOO_COMPLICATED;
        }
        if (method.isSynchronized()) {
            return ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult.ANALYSIS_TOO_COMPLICATED;
        }
        GraphBuilderConfiguration graphBuilderConfig = this.prototypeGraphBuilderConfig.copy();
        graphBuilderConfig.getPlugins().appendInlineInvokePlugin((InlineInvokePlugin)new TrivialChildrenInline(callSite));
        graphBuilderConfig.getPlugins().appendParameterPlugin((ParameterPlugin)new TrivialMethodDetectorParameterPlugin(args));
        MethodNodeTracking methodNodeTracking = new MethodNodeTracking();
        StructuredGraph graph = new StructuredGraph.Builder(this.options, this.debug).method((ResolvedJavaMethod)method).build();
        try (DebugContext.Scope ignored = this.debug.scope((Object)"InlineDuringParsingAnalysis", (Object)graph, (Object)method, (Object)this);){
            TrivialMethodDetectorGraphBuilderPhase builderPhase = new TrivialMethodDetectorGraphBuilderPhase((Providers)this.providers, graphBuilderConfig, OptimisticOptimizations.NONE, null, this.providers.getWordTypes());
            try (Graph.NodeEventScope ignored1 = graph.trackNodeEvents((Graph.NodeEventListener)methodNodeTracking);){
                builderPhase.apply(graph);
            }
            this.debug.dump(3, (Object)graph, "InlineDuringParsingAnalysis successful");
            ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResultInline invocationResultInline = new ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResultInline(callSite, method);
            return invocationResultInline;
        }
        catch (TrivialMethodDetectorBailoutException ex) {
            this.debug.dump(3, (Object)graph, "InlineDuringParsingAnalysis failed with %s", (Object)ex);
            return ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult.ANALYSIS_TOO_COMPLICATED;
        }
        catch (Throwable ex) {
            if (!Assertions.assertionsEnabled()) return ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult.ANALYSIS_TOO_COMPLICATED;
            throw this.debug.handle(ex);
        }
    }

    class TrivialChildrenInline
    implements InlineInvokePlugin {
        private final ExperimentalNativeImageInlineDuringParsingPlugin.CallSite callSite;

        TrivialChildrenInline(ExperimentalNativeImageInlineDuringParsingPlugin.CallSite callSite) {
            this.callSite = callSite;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod callee, ValueNode[] args) {
            if (ExperimentalNativeImageInlineDuringParsingPlugin.inliningBeforeAnalysisNotAllowed(b, callee, b.getMethod())) {
                return null;
            }
            List<Pair<ResolvedJavaMethod, Integer>> callingContext = this.concatCallingContexts(b.getCallingContext());
            if (ExperimentalNativeImageInlineDuringParsingPlugin.isRecursiveCall(callingContext, callee)) {
                return null;
            }
            ExperimentalNativeImageInlineDuringParsingPlugin.CallSite newCallSite = new ExperimentalNativeImageInlineDuringParsingPlugin.CallSite(callingContext, ExperimentalNativeImageInlineDuringParsingPlugin.toAnalysisMethod(callee));
            ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult inline = TrivialMethodDetector.this.analyzeMethod(newCallSite, (AnalysisMethod)callee, args);
            if (inline instanceof ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResultInline) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)callee);
            }
            return null;
        }

        private List<Pair<ResolvedJavaMethod, Integer>> concatCallingContexts(List<Pair<ResolvedJavaMethod, Integer>> baseContext) {
            for (int i = 0; i < this.callSite.getLength(); ++i) {
                baseContext.add((Pair<ResolvedJavaMethod, Integer>)Pair.create((Object)this.callSite.getCaller()[i], (Object)this.callSite.getBci()[i]));
            }
            return baseContext;
        }
    }

    static class MethodNodeTracking
    extends Graph.NodeEventListener {
        MethodNodeTracking() {
        }

        public void nodeAdded(Node node) {
            if (!(node instanceof ConstantNode || node instanceof ParameterNode || node instanceof ReturnNode || node instanceof LoadFieldNode)) {
                if (node instanceof FrameState) {
                    if (((FrameState)node).bci != 0) {
                        throw new TrivialMethodDetectorBailoutException("Only frame state for the start node is allowed: " + node);
                    }
                } else if (!(node instanceof NewArrayNode) && !(node instanceof NewInstanceNode)) {
                    throw new TrivialMethodDetectorBailoutException("Node not allowed: " + node);
                }
            }
        }
    }
}

