/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.gms.admin.GMSAnnounceSupplementalInfo;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="_gms-announce-after-start-cluster-command")
@Supplemental(value="start-cluster", on=Supplemental.Timing.After, ifFailure=FailurePolicy.Warn)
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_gms-announce-after-start-cluster-command", description="_gms-announce-after-start-cluster-command")})
public class GMSAnnounceAfterStartClusterCommand
implements AdminCommand {
    private static final String GMS_ADMIN_LOGGER_NAME = "javax.enterprise.cluster.gms.admin";
    private static final String LOG_MESSAGES_RB = "org.glassfish.cluster.gms.LogMessages";
    static final Logger GMS_ADMIN_LOGGER = Logger.getLogger("javax.enterprise.cluster.gms.admin", "org.glassfish.cluster.gms.LogMessages");
    private static final String GMSADMIN_AFTER_START = "NCLS-CLSTR-30001";
    private static final String GMS_START_EXCEPTION = "NCLS-CLSTR-30002";
    @Inject
    private ServerEnvironment env;
    @Inject
    private ServiceLocator habitat;
    @Param(optional=false, primary=true)
    private String clusterName;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Inject
    GMSAdapterService gmsAdapterService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        GMSAnnounceAfterStartClusterCommand.announceGMSGroupStartupComplete(this.clusterName, report);
    }

    public static void announceGMSGroupStartupComplete(String clusterName, ActionReport report) {
        GMSAnnounceSupplementalInfo gmsInfo;
        if (report != null && (gmsInfo = (GMSAnnounceSupplementalInfo)report.getResultType(GMSAnnounceSupplementalInfo.class)) != null && gmsInfo.gmsInitiated) {
            LinkedList members = null;
            GMSConstants.groupStartupState groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_FAILED;
            switch (report.getActionExitCode()) {
                case SUCCESS: {
                    members = gmsInfo.clusterMembers;
                    groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_SUCCESS;
                    break;
                }
                case FAILURE: {
                    members = gmsInfo.clusterMembers;
                    groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_FAILED;
                    break;
                }
                case WARNING: {
                    members = (LinkedList)report.getResultType(List.class);
                    groupStartupState2 = GMSConstants.groupStartupState.COMPLETED_FAILED;
                    break;
                }
            }
            GMS_ADMIN_LOGGER.log(LogLevel.INFO, GMSADMIN_AFTER_START, new Object[]{report.getActionExitCode(), members, gmsInfo.clusterMembers});
            try {
                if (gmsInfo.gms != null) {
                    if (members == null) {
                        members = new LinkedList();
                    }
                    gmsInfo.gms.announceGroupStartup(clusterName, groupStartupState2, members);
                }
            }
            catch (Throwable t) {
                GMS_ADMIN_LOGGER.log(LogLevel.WARNING, GMS_START_EXCEPTION, t.getLocalizedMessage());
            }
        }
    }
}

