/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.FailureDetection;
import com.sun.enterprise.config.serverbeans.GroupManagementService;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="gmsupgrade")
public class GMSConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Clusters clusters;
    @Inject
    Configs configs;

    public void postConstruct() {
        try {
            this.upgradeClusterElements();
            this.upgradeGroupManagementServiceElements();
        }
        catch (Exception e) {
            LogRecord lr = new LogRecord(Level.SEVERE, "Failure while upgrading cluster data from V2 to V3: " + e);
            lr.setLoggerName(this.getClass().getName());
            EarlyLogHandler.earlyMessages.add(lr);
            throw new RuntimeException(e);
        }
    }

    private void upgradeClusterElements() throws TransactionFailure {
        List clusterList = this.clusters.getCluster();
        for (Cluster cl : clusterList) {
            ConfigSupport.apply((SingleConfigCode)new ClusterConfigCode(), (ConfigBeanProxy)cl);
        }
    }

    private void upgradeGroupManagementServiceElements() throws TransactionFailure {
        List lconfigs = this.configs.getConfig();
        for (Config c : lconfigs) {
            LogRecord lr = new LogRecord(Level.FINE, "Upgrade config " + c.getName());
            lr.setLoggerName(this.getClass().getName());
            EarlyLogHandler.earlyMessages.add(lr);
            ConfigSupport.apply((SingleConfigCode)new GroupManagementServiceConfigCode(), (ConfigBeanProxy)c);
        }
    }

    private String generateHeartbeatPort() {
        int MIN_GMS_MULTICAST_PORT = 2048;
        int MAX_GMS_MULTICAST_PORT = 32000;
        int portInterval = 29952;
        return Integer.valueOf(Math.round((float)(Math.random() * (double)portInterval)) + 2048).toString();
    }

    private String generateHeartbeatAddress() {
        int MAX_GMS_MULTICAST_ADDRESS_SUBRANGE = 255;
        StringBuffer heartbeatAddressBfr = new StringBuffer("228.9.");
        heartbeatAddressBfr.append(Math.round(Math.random() * 255.0)).append('.').append(Math.round(Math.random() * 255.0));
        return heartbeatAddressBfr.toString();
    }

    private static class GroupManagementServiceConfigCode
    implements SingleConfigCode<Config> {
        private GroupManagementServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            Property prop;
            GroupManagementService gms = config.getGroupManagementService();
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)config);
            gms = (GroupManagementService)t.enroll((ConfigBeanProxy)gms);
            String value = gms.getPingProtocolTimeoutInMillis();
            if (value != null) {
                try {
                    gms.setGroupDiscoveryTimeoutInMillis(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setPingProtocolTimeoutInMillis(null);
            }
            FailureDetection fd = gms.getFailureDetection();
            fd = (FailureDetection)t.enroll((ConfigBeanProxy)fd);
            value = gms.getFdProtocolTimeoutInMillis();
            if (value != null) {
                try {
                    fd.setHeartbeatFrequencyInMillis(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setFdProtocolTimeoutInMillis(null);
            }
            if ((value = gms.getFdProtocolMaxTries()) != null) {
                try {
                    fd.setMaxMissedHeartbeats(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setFdProtocolMaxTries(null);
            }
            if ((value = gms.getVsProtocolTimeoutInMillis()) != null) {
                try {
                    fd.setVerifyFailureWaittimeInMillis(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setVsProtocolTimeoutInMillis(null);
            }
            if ((prop = gms.getProperty("failure-detection-tcp-retransmit-timeout")) != null && prop.getValue() != null) {
                try {
                    fd.setVerifyFailureConnectTimeoutInMillis(prop.getValue().trim());
                }
                catch (Throwable re) {
                    // empty catch block
                }
                List props = gms.getProperty();
                props.remove(prop);
            }
            if (gms.getMergeProtocolMinIntervalInMillis() != null) {
                gms.setMergeProtocolMinIntervalInMillis(null);
            }
            if (gms.getMergeProtocolMaxIntervalInMillis() != null) {
                gms.setMergeProtocolMaxIntervalInMillis(null);
            }
            return config;
        }
    }

    private class ClusterConfigCode
    implements SingleConfigCode<Cluster> {
        private ClusterConfigCode() {
        }

        public Object run(Cluster cluster) throws PropertyVetoException, TransactionFailure {
            Property prop;
            String value = cluster.getHeartbeatEnabled();
            if (value != null) {
                cluster.setGmsEnabled(value);
                cluster.setHeartbeatEnabled(null);
            }
            if ((value = cluster.getHeartbeatAddress()) != null) {
                try {
                    cluster.setGmsMulticastAddress(value);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cluster.setHeartbeatAddress(null);
            }
            if (cluster.getGmsMulticastAddress() == null) {
                cluster.setGmsMulticastAddress(GMSConfigUpgrade.this.generateHeartbeatAddress());
            }
            if ((value = cluster.getHeartbeatPort()) != null) {
                try {
                    cluster.setGmsMulticastPort(value);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cluster.setHeartbeatPort(null);
            }
            if (cluster.getGmsMulticastPort() == null) {
                cluster.setGmsMulticastPort(GMSConfigUpgrade.this.generateHeartbeatPort());
            }
            if ((prop = cluster.getProperty("gms-bind-interface-address")) != null && prop.getValue() != null) {
                cluster.setGmsBindInterfaceAddress(prop.getValue());
                List props = cluster.getProperty();
                props.remove(prop);
            } else {
                value = cluster.getGmsBindInterfaceAddress();
                if (value == null) {
                    cluster.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", cluster.getName()));
                }
            }
            Property gmsListenerPort = (Property)cluster.createChild(Property.class);
            gmsListenerPort.setName("GMS_LISTENER_PORT");
            gmsListenerPort.setValue(String.format("${GMS_LISTENER_PORT-%s}", cluster.getName()));
            cluster.getProperty().add(gmsListenerPort);
            return cluster;
        }
    }
}

