/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.messageinterpolation;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.validation.MessageInterpolator;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.messageinterpolation.FormatterWrapper;
import org.hibernate.validator.internal.engine.messageinterpolation.InterpolationTermType;
import org.hibernate.validator.internal.engine.messageinterpolation.el.SimpleELContext;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class InterpolationTerm {
    private static final Log log = LoggerFactory.make();
    private static final String VALIDATED_VALUE_NAME = "validatedValue";
    private static final String EL_DESIGNATION_CHARACTER = "$";
    private static final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();
    private final String expression;
    private final InterpolationTermType type;
    private final Locale locale;

    public InterpolationTerm(String expression, Locale locale) {
        this.locale = locale;
        this.expression = expression;
        this.type = expression.startsWith(EL_DESIGNATION_CHARACTER) ? InterpolationTermType.EL : InterpolationTermType.PARAMETER;
    }

    public String interpolate(MessageInterpolator.Context context) {
        if (InterpolationTermType.EL.equals((Object)this.type)) {
            return this.interpolateExpressionLanguageTerm(context);
        }
        return this.interpolateConstraintAnnotationValue(context);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InterpolationExpression");
        sb.append("{expression='").append(this.expression).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }

    private String interpolateExpressionLanguageTerm(MessageInterpolator.Context context) {
        String resolvedExpression = this.expression;
        SimpleELContext elContext = new SimpleELContext();
        try {
            ValueExpression valueExpression = this.bindContextValues(this.expression, context, elContext);
            resolvedExpression = (String)valueExpression.getValue((ELContext)elContext);
        }
        catch (PropertyNotFoundException pnfe) {
            log.unknownPropertyInExpressionLanguage(this.expression, (Exception)((Object)pnfe));
        }
        catch (ELException e) {
            log.errorInExpressionLanguage(this.expression, (Exception)((Object)e));
        }
        catch (Exception e) {
            log.evaluatingExpressionLanguageExpressionCausedException(this.expression, e);
        }
        return resolvedExpression;
    }

    private String interpolateConstraintAnnotationValue(MessageInterpolator.Context context) {
        Object variable = context.getConstraintDescriptor().getAttributes().get(this.removeCurlyBraces(this.expression));
        String resolvedExpression = variable != null ? (variable.getClass().isArray() ? Arrays.toString((Object[])variable) : variable.toString()) : this.expression;
        return resolvedExpression;
    }

    private String removeCurlyBraces(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private ValueExpression bindContextValues(String messageTemplate, MessageInterpolator.Context messageInterpolatorContext, SimpleELContext elContext) {
        ValueExpression valueExpression = expressionFactory.createValueExpression(messageInterpolatorContext.getValidatedValue(), Object.class);
        elContext.setVariable(VALIDATED_VALUE_NAME, valueExpression);
        valueExpression = expressionFactory.createValueExpression((Object)new FormatterWrapper(this.locale), FormatterWrapper.class);
        elContext.setVariable("formatter", valueExpression);
        for (Map.Entry<String, Object> entry : messageInterpolatorContext.getConstraintDescriptor().getAttributes().entrySet()) {
            valueExpression = expressionFactory.createValueExpression(entry.getValue(), Object.class);
            elContext.setVariable(entry.getKey(), valueExpression);
        }
        if (messageInterpolatorContext instanceof MessageInterpolatorContext) {
            MessageInterpolatorContext internalContext = (MessageInterpolatorContext)messageInterpolatorContext;
            for (Map.Entry<String, Object> entry : internalContext.getMessageParameters().entrySet()) {
                valueExpression = expressionFactory.createValueExpression(entry.getValue(), Object.class);
                elContext.setVariable(entry.getKey(), valueExpression);
            }
        }
        return expressionFactory.createValueExpression((ELContext)elContext, messageTemplate, String.class);
    }
}

