/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.nexus.client.beans;

import java.io.File;
import javax.xml.bind.annotation.XmlType;

@XmlType
public final class MavenArtifactInfo {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier = null;
    private String extension = null;
    private File file;

    public MavenArtifactInfo(String groupId, String artifactId, String version, String classifier, String extension, File file) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
        this.file = file;
    }

    public MavenArtifactInfo() {
    }

    public File getFile() {
        return this.file;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId);
        sb.append(':');
        sb.append(this.artifactId);
        sb.append(':');
        if (this.extension != null && !this.extension.isEmpty()) {
            sb.append(this.extension);
            sb.append(':');
        }
        if (this.classifier != null && !this.classifier.isEmpty()) {
            sb.append(this.classifier);
            sb.append(':');
        }
        sb.append(this.version);
        return sb.toString();
    }

    public String getRepositoryDirRelativePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId.replace('.', '/'));
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('/');
        sb.append(this.version);
        return sb.toString();
    }

    public String getRepositoryRelativePath() {
        StringBuilder sb = new StringBuilder(this.getRepositoryDirRelativePath());
        sb.append('/');
        sb.append(this.artifactId);
        sb.append('-');
        sb.append(this.version);
        sb.append('.');
        sb.append(this.extension);
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.groupId != null ? this.groupId.hashCode() : 0);
        hash = 97 * hash + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        hash = 97 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 97 * hash + (this.classifier != null ? this.classifier.hashCode() : 0);
        hash = 97 * hash + (this.extension != null ? this.extension.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifactInfo other = (MavenArtifactInfo)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        return !(this.extension == null ? other.extension != null : !this.extension.equals(other.extension));
    }
}

