/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.nexus.mojos;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.nexus.client.beans.MavenArtifactInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingRepoConf {
    String ref;
    String profile;
    private MavenArtifactInfo artifactInfo;

    protected MavenArtifactInfo getArtifactInfo() {
        return this.artifactInfo;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getRef() {
        return this.ref;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    private static Artifact parseCoordinates(String coordinates, String projectVersion) {
        String[] referenceCoordinatesTokens = coordinates.split(":");
        if (referenceCoordinatesTokens.length < 2) {
            return null;
        }
        String version = projectVersion;
        if (referenceCoordinatesTokens.length > 2) {
            version = referenceCoordinatesTokens[2];
        }
        String packaging = "jar";
        if (referenceCoordinatesTokens.length > 3) {
            packaging = referenceCoordinatesTokens[3];
        }
        return new DefaultArtifact(referenceCoordinatesTokens[0], referenceCoordinatesTokens[1], VersionRange.createFromVersion((String)version), "runtime", packaging, null, (ArtifactHandler)new DefaultArtifactHandler(packaging));
    }

    public MavenArtifactInfo getRefArtifact(String version, ArtifactResolver resolver, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws MojoFailureException {
        if (this.artifactInfo == null) {
            Artifact a = StagingRepoConf.parseCoordinates(this.ref, version);
            try {
                resolver.resolve(a, remoteRepositories, localRepository);
            }
            catch (ArtifactResolutionException ex) {
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
            catch (ArtifactNotFoundException ex) {
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
            this.artifactInfo = new MavenArtifactInfo(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getType(), a.getFile());
        }
        return this.artifactInfo;
    }
}

