/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.io.Serializable;
import java.util.Arrays;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.jts.DimensionalCoordinate;

class PointSequenceCoordinateSequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    PointSequenceCoordinateSequenceFactory() {
    }

    public CoordinateSequence create(Coordinate[] coordinates) {
        CoordinateReferenceSystem<?> crs = this.determineCRS(coordinates);
        return this.fromCoordinateArray(coordinates, crs);
    }

    public CoordinateSequence create(CoordinateSequence coordSeq) {
        return coordSeq;
    }

    public CoordinateSequence create(int size, int dimension) {
        if (dimension > 3) {
            throw new IllegalArgumentException("dimension must be <= 3");
        }
        return new CoordinateArraySequence(size, dimension);
    }

    public <P extends Position> PositionSequence<P> toPositionSequence(CoordinateSequence cs, Class<P> posType, CoordinateReferenceSystem<P> crs) {
        if (cs instanceof PositionSequence && ((PositionSequence)cs).getPositionClass().equals(posType)) {
            return (PositionSequence)cs;
        }
        Coordinate c = new Coordinate();
        double[] psc = new double[crs.getCoordinateDimension()];
        Arrays.fill(psc, Double.NaN);
        PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(cs.size(), posType);
        for (int i = 0; i < cs.size(); ++i) {
            psc[0] = cs.getOrdinate(i, 0);
            psc[1] = cs.getOrdinate(i, 1);
            if (CoordinateReferenceSystems.hasVerticalAxis(crs)) {
                psc[2] = cs.getOrdinate(i, 2);
            }
            if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
                double mOrdinate;
                int idxM = CoordinateReferenceSystems.hasVerticalAxis(crs) ? 3 : 2;
                psc[idxM] = mOrdinate = cs.getOrdinate(i, 3);
            }
            builder.add(psc);
        }
        return builder.toPositionSequence();
    }

    private CoordinateReferenceSystem<?> determineCRS(Coordinate[] coordinates) {
        boolean hasZ;
        boolean hasM = false;
        if (coordinates == null || coordinates.length == 0) {
            return CoordinateReferenceSystems.PROJECTED_2D_METER;
        }
        if (coordinates[0] instanceof DimensionalCoordinate) {
            hasM = !Double.isNaN(((DimensionalCoordinate)coordinates[0]).getM());
        }
        boolean bl = hasZ = !Double.isNaN(coordinates[0].z);
        if (hasM && hasZ) {
            return CoordinateReferenceSystems.PROJECTED_3DM_METER;
        }
        if (hasM) {
            return CoordinateReferenceSystems.PROJECTED_2DM_METER;
        }
        if (hasZ) {
            return CoordinateReferenceSystems.PROJECTED_3D_METER;
        }
        return CoordinateReferenceSystems.PROJECTED_2D_METER;
    }

    private <P extends Position> CoordinateSequence fromCoordinateArray(Coordinate[] coordinates, CoordinateReferenceSystem<P> crs) {
        PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(coordinates.length, crs.getPositionClass());
        double[] ordinates = new double[crs.getCoordinateDimension()];
        for (Coordinate co : coordinates) {
            this.copy(co, ordinates, crs);
            builder.add(ordinates);
        }
        return (CoordinateSequence)builder.toPositionSequence();
    }

    private <P extends Position> void copy(Coordinate co, double[] ordinates, CoordinateReferenceSystem<P> crs) {
        ordinates[0] = co.x;
        ordinates[1] = co.y;
        boolean hasVerticalAxis = CoordinateReferenceSystems.hasVerticalAxis(crs);
        if (hasVerticalAxis) {
            ordinates[2] = co.z;
        }
        if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
            int idxM = hasVerticalAxis ? 3 : 2;
            ordinates[idxM] = co instanceof DimensionalCoordinate ? ((DimensionalCoordinate)co).m : Double.NaN;
        }
    }
}

