/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.codec.sqlserver.CountingPointSequenceBuilder;
import org.geolatte.geom.codec.sqlserver.Encoder;
import org.geolatte.geom.codec.sqlserver.Figure;
import org.geolatte.geom.codec.sqlserver.Shape;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

abstract class AbstractEncoder<G extends Geometry>
implements Encoder<G> {
    AbstractEncoder() {
    }

    @Override
    public SqlServerGeometry encode(G geom) {
        SqlServerGeometry nativeGeom = new SqlServerGeometry();
        int srid = ((Geometry)geom).getSRID();
        nativeGeom.setSrid(srid < 0 ? 0 : srid);
        nativeGeom.setIsValid();
        if (((Geometry)geom).isMeasured()) {
            nativeGeom.setHasMValues();
        }
        CountingPointSequenceBuilder coordinates = new CountingPointSequenceBuilder(((Geometry)geom).getDimensionalFlag(), ((Geometry)geom).getCrsId());
        ArrayList<Figure> figures = new ArrayList<Figure>();
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        this.encode((Geometry)geom, -1, coordinates, (List<Figure>)figures, (List<Shape>)shapes);
        this.encodePoints(nativeGeom, coordinates.toPointSequence());
        this.encodeFigures(nativeGeom, figures);
        this.encodeShapes(nativeGeom, shapes);
        return nativeGeom;
    }

    protected abstract void encode(Geometry var1, int var2, CountingPointSequenceBuilder var3, List<Figure> var4, List<Shape> var5);

    protected void encodeShapes(SqlServerGeometry nativeGeom, List<Shape> shapes) {
        nativeGeom.setNumberOfShapes(shapes.size());
        for (int i = 0; i < shapes.size(); ++i) {
            nativeGeom.setShape(i, shapes.get(i));
        }
    }

    protected void encodeFigures(SqlServerGeometry nativeGeom, List<Figure> figures) {
        nativeGeom.setNumberOfFigures(figures.size());
        for (int i = 0; i < figures.size(); ++i) {
            nativeGeom.setFigure(i, figures.get(i));
        }
    }

    protected void encodePoints(SqlServerGeometry nativeGeom, PointCollection coordinates) {
        nativeGeom.setNumberOfPoints(coordinates.size());
        nativeGeom.allocateMValueArray();
        for (int i = 0; i < coordinates.size(); ++i) {
            this.setCoordinate(nativeGeom, i, coordinates);
        }
    }

    protected void setCoordinate(SqlServerGeometry nativeGeom, int idx, PointCollection coordinate) {
        if (!nativeGeom.hasZValues() && !Double.isNaN(coordinate.getZ(idx))) {
            nativeGeom.setHasZValues();
            nativeGeom.allocateZValueArray();
        }
        nativeGeom.setCoordinate(idx, coordinate);
    }
}

