/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.ExactCoordinatePointEquality;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryEquality;
import org.geolatte.geom.PointCollectionEquality;
import org.geolatte.geom.PointCollectionPointEquality;
import org.geolatte.geom.PointEquality;
import org.geolatte.geom.Polygon;

public class GeometryPointEquality
implements GeometryEquality {
    private final PointCollectionEquality pointSeqEq;

    public GeometryPointEquality(PointEquality pointEq) {
        this.pointSeqEq = new PointCollectionPointEquality(pointEq);
    }

    public GeometryPointEquality() {
        ExactCoordinatePointEquality pointEquality = new ExactCoordinatePointEquality();
        this.pointSeqEq = new PointCollectionPointEquality(pointEquality);
    }

    @Override
    public boolean equals(Geometry first, Geometry second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.isEmpty() && second.isEmpty()) {
            return true;
        }
        if (first.isEmpty() || second.isEmpty()) {
            return false;
        }
        if (!first.getCrsId().equals(second.getCrsId())) {
            return false;
        }
        if (first.getGeometryType() != second.getGeometryType()) {
            return false;
        }
        if (first instanceof GeometryCollection) {
            assert (second instanceof GeometryCollection);
            return this.equals((GeometryCollection)first, (GeometryCollection)second);
        }
        if (first instanceof Polygon) {
            assert (second instanceof Polygon);
            return this.equals((Polygon)first, (Polygon)second);
        }
        return this.pointSeqEq.equals(first.getPoints(), second.getPoints());
    }

    private boolean equals(Polygon first, Polygon second) {
        if (first.getNumInteriorRing() != second.getNumInteriorRing()) {
            return false;
        }
        if (!this.equals(first.getExteriorRing(), second.getExteriorRing())) {
            return false;
        }
        for (int i = 0; i < first.getNumInteriorRing(); ++i) {
            if (this.equals(first.getInteriorRingN(i), second.getInteriorRingN(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(GeometryCollection first, GeometryCollection second) {
        if (first.getNumGeometries() != second.getNumGeometries()) {
            return false;
        }
        for (int i = 0; i < first.getNumGeometries(); ++i) {
            if (this.equals(first.getGeometryN(i), second.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }
}

