/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.fx;

import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.image.Image;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.Sample;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.elements.AppSink;

public class FXImageSink {
    private static final String DEFAULT_CAPS = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "video/x-raw, format=BGRx" : "video/x-raw, format=xRGB";
    private final AppSink sink;
    private final ReadOnlyObjectWrapper<Image> image;
    private final AtomicReference<Sample> pending;
    private final NewSampleListener newSampleListener;
    private final NewPrerollListener newPrerollListener;
    private Sample activeSample;
    private Buffer activeBuffer;
    private int requestWidth;
    private int requestHeight;
    private int requestRate;

    public FXImageSink() {
        this(new AppSink("FXImageSink"));
    }

    public FXImageSink(AppSink sink) {
        this.sink = sink;
        sink.set("emit-signals", (Object)true);
        this.newSampleListener = new NewSampleListener();
        this.newPrerollListener = new NewPrerollListener();
        sink.connect((AppSink.NEW_SAMPLE)this.newSampleListener);
        sink.connect((AppSink.NEW_PREROLL)this.newPrerollListener);
        sink.setCaps(Caps.fromString((String)DEFAULT_CAPS));
        this.image = new ReadOnlyObjectWrapper();
        this.pending = new AtomicReference();
    }

    public ReadOnlyObjectProperty<Image> imageProperty() {
        return this.image.getReadOnlyProperty();
    }

    public AppSink getSinkElement() {
        return this.sink;
    }

    public void clear() {
        if (Platform.isFxApplicationThread()) {
            this.clearImage();
        } else {
            Platform.runLater(() -> this.clearImage());
        }
    }

    public FXImageSink requestFrameSize(int width, int height) {
        this.requestWidth = width;
        this.requestHeight = height;
        this.sink.setCaps(Caps.fromString((String)this.buildCapsString()));
        return this;
    }

    public FXImageSink requestFrameRate(double rate) {
        this.requestRate = (int)Math.round(rate);
        this.sink.setCaps(Caps.fromString((String)this.buildCapsString()));
        return this;
    }

    private String buildCapsString() {
        if (this.requestWidth < 1 && this.requestHeight < 1 && this.requestRate < 1) {
            return DEFAULT_CAPS;
        }
        StringBuilder sb = new StringBuilder(DEFAULT_CAPS);
        if (this.requestWidth > 0) {
            sb.append(",width=");
            sb.append(this.requestWidth);
        }
        if (this.requestHeight > 0) {
            sb.append(",height=");
            sb.append(this.requestHeight);
        }
        if (this.requestRate > 0) {
            sb.append(",framerate=");
            sb.append(this.requestRate);
            sb.append("/1");
        }
        return sb.toString();
    }

    private void updateImage() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on FX application thread");
        }
        Sample newSample = this.pending.getAndSet(null);
        if (newSample == null) {
            return;
        }
        Sample oldSample = this.activeSample;
        Buffer oldBuffer = this.activeBuffer;
        this.activeSample = newSample;
        Structure capsStruct = newSample.getCaps().getStructure(0);
        int width = capsStruct.getInteger("width");
        int height = capsStruct.getInteger("height");
        this.activeBuffer = newSample.getBuffer();
        PixelBuffer pixelBuffer = new PixelBuffer(width, height, (java.nio.Buffer)this.activeBuffer.map(false), (PixelFormat)PixelFormat.getByteBgraPreInstance());
        WritableImage img = new WritableImage(pixelBuffer);
        this.image.set((Object)img);
        if (oldBuffer != null) {
            oldBuffer.unmap();
        }
        if (oldSample != null) {
            oldSample.dispose();
        }
    }

    private void clearImage() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on FX application thread");
        }
        Sample newSample = this.pending.getAndSet(null);
        if (newSample != null) {
            newSample.dispose();
        }
        this.image.set(null);
        if (this.activeBuffer != null) {
            this.activeBuffer.unmap();
            this.activeBuffer = null;
        }
        if (this.activeSample != null) {
            this.activeSample.dispose();
            this.activeSample = null;
        }
    }

    private class NewPrerollListener
    implements AppSink.NEW_PREROLL {
        private NewPrerollListener() {
        }

        public FlowReturn newPreroll(AppSink appsink) {
            Sample s = appsink.pullPreroll();
            if ((s = FXImageSink.this.pending.getAndSet(s)) != null) {
                s.dispose();
            }
            Platform.runLater(() -> FXImageSink.this.updateImage());
            return FlowReturn.OK;
        }
    }

    private class NewSampleListener
    implements AppSink.NEW_SAMPLE {
        private NewSampleListener() {
        }

        public FlowReturn newSample(AppSink appsink) {
            Sample s = appsink.pullSample();
            if ((s = FXImageSink.this.pending.getAndSet(s)) != null) {
                s.dispose();
            }
            Platform.runLater(() -> FXImageSink.this.updateImage());
            return FlowReturn.OK;
        }
    }
}

