/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.clean.database;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.core.extensibility.CleanModePlugin;
import org.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.database.sqlserver.SQLServerDatabase;

public class SQLServerCleanModePlugin
implements CleanModePlugin<SQLServerDatabase> {
    public boolean handlesMode(CleanModeConfigurationExtension.Mode cleanMode) {
        return cleanMode == CleanModeConfigurationExtension.Mode.ALL;
    }

    public boolean handlesDatabase(Database database) {
        return database instanceof SQLServerDatabase;
    }

    public void cleanDatabasePostSchema(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        if (this.supportsColumnEncryptionKeys(database)) {
            for (String statement : this.cleanColumnEncryptionKeys(database, jdbcTemplate)) {
                jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.supportsColumnMasterKeys(database)) {
            for (String statement : this.cleanColumnMasterKeys(database, jdbcTemplate)) {
                jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        for (String statement : this.cleanSymmetricKey(database, jdbcTemplate)) {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanEventNotifications(database, jdbcTemplate)) {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanDatabaseExtendedProperties(database, jdbcTemplate)) {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanDatabaseRoles(database, jdbcTemplate)) {
            this.executeIgnoringErrors(jdbcTemplate, statement);
        }
        boolean oldAutoCommit = jdbcTemplate.getConnection().getAutoCommit();
        jdbcTemplate.getConnection().setAutoCommit(true);
        for (String statement : this.cleanFulltextStoplist(database, jdbcTemplate)) {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanSearchPropertyList(database, jdbcTemplate)) {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.cleanFullTextCatalogs(database, jdbcTemplate)) {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        jdbcTemplate.getConnection().setAutoCommit(oldAutoCommit);
    }

    private void executeIgnoringErrors(JdbcTemplate jdbcTemplate, String statement) {
        try {
            jdbcTemplate.execute(statement, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean supportsColumnEncryptionKeys(SQLServerDatabase database) {
        return database.getVersion().isAtLeast("13");
    }

    private boolean supportsColumnMasterKeys(SQLServerDatabase database) {
        return database.getVersion().isAtLeast("13");
    }

    private List<String> cleanFullTextCatalogs(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.fulltext_catalogs", new String[0]).stream().map(name -> "DROP FULLTEXT CATALOG " + database.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanColumnEncryptionKeys(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.column_encryption_keys", new String[0]).stream().map(name -> "DROP COLUMN ENCRYPTION KEY " + database.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanColumnMasterKeys(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.column_master_keys", new String[0]).stream().map(name -> "DROP COLUMN MASTER KEY " + database.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanSymmetricKey(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.symmetric_keys", new String[0]).stream().map(name -> "DROP SYMMETRIC KEY " + database.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanEventNotifications(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.event_notifications", new String[0]).stream().map(name -> "DROP EVENT NOTIFICATION " + database.quote(new String[]{name}) + " ON DATABASE").collect(Collectors.toList());
    }

    private List<String> cleanDatabaseExtendedProperties(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.extended_properties WHERE class = 0", new String[0]).stream().map(name -> "EXEC sp_dropextendedproperty  @name= " + database.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanDatabaseRoles(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.database_principals WHERE (type = 'A' OR type = 'R') AND is_fixed_role = 0", new String[0]).stream().map(name -> "DROP ROLE " + database.quote(new String[]{name})).collect(Collectors.toList());
    }

    private List<String> cleanFulltextStoplist(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.fulltext_stoplists", new String[0]).stream().map(name -> "DROP FULLTEXT STOPLIST " + database.quote(new String[]{name}) + ";").collect(Collectors.toList());
    }

    private List<String> cleanSearchPropertyList(SQLServerDatabase database, JdbcTemplate jdbcTemplate) throws SQLException {
        return jdbcTemplate.queryForStringList("SELECT name FROM sys.registered_search_property_lists", new String[0]).stream().map(name -> "DROP SEARCH PROPERTY LIST " + database.quote(new String[]{name}) + ";").collect(Collectors.toList());
    }
}

