/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.ExecutionTemplate;
import org.flywaydb.core.internal.jdbc.PlainExecutionTemplate;
import org.flywaydb.core.internal.jdbc.TableLockingExecutionTemplate;

public class ExecutionTemplateFactory {
    public static ExecutionTemplate createExecutionTemplate(Connection connection) {
        return ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, true, DatabaseTypeRegister.getDatabaseTypeForConnection(connection));
    }

    public static ExecutionTemplate createExecutionTemplate(Connection connection, Database database) {
        if (database.supportsMultiStatementTransactions()) {
            return ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, true, database.getDatabaseType());
        }
        return new PlainExecutionTemplate();
    }

    public static ExecutionTemplate createTableExclusiveExecutionTemplate(Connection connection, Table table, Database database) {
        if (database.supportsMultiStatementTransactions()) {
            return new TableLockingExecutionTemplate(table, ExecutionTemplateFactory.createTransactionalExecutionTemplate(connection, database.supportsDdlTransactions(), database.getDatabaseType()));
        }
        return new TableLockingExecutionTemplate(table, new PlainExecutionTemplate());
    }

    private static ExecutionTemplate createTransactionalExecutionTemplate(Connection connection, boolean rollbackOnException, DatabaseType databaseType) {
        return databaseType.createTransactionalExecutionTemplate(connection, rollbackOnException);
    }
}

