/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.utils.chromium;

import org.fluentlenium.utils.chromium.ChromiumApi;
import org.fluentlenium.utils.chromium.ChromiumApiNotSupportedException;
import org.fluentlenium.utils.chromium.ChromiumControl;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class ChromiumControlImpl
implements ChromiumControl {
    private WebDriver driver;

    public ChromiumControlImpl(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public final ChromiumApi getChromiumApi() {
        RemoteWebDriver remoteWebDriver;
        if (this.driver instanceof EventFiringWebDriver) {
            this.driver = ((EventFiringWebDriver)this.driver).getWrappedDriver();
        }
        try {
            remoteWebDriver = (RemoteWebDriver)this.driver;
        }
        catch (ClassCastException ex) {
            throw new ChromiumApiNotSupportedException("API supported only by Chrome and Edge", ex.getCause());
        }
        return new ChromiumApi(remoteWebDriver);
    }
}

