/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.utils;

import java.lang.annotation.Annotation;
import org.fluentlenium.adapter.exception.AnnotationNotFoundException;
import org.fluentlenium.adapter.exception.MethodNotFoundException;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static <T extends Annotation> T getClassAnnotationForClass(Class<T> annotation, Class<?> classFromThread) {
        T definedAnnotation = classFromThread.getAnnotation(annotation);
        if (definedAnnotation == null) {
            throw new AnnotationNotFoundException();
        }
        return definedAnnotation;
    }

    public static <T extends Annotation> T getMethodAnnotationForMethod(Class<T> annotation, Class<?> classFromThread, String methodNameFromThread) {
        T definedAnnotation;
        try {
            definedAnnotation = classFromThread.getDeclaredMethod(methodNameFromThread, new Class[0]).getAnnotation(annotation);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(e);
        }
        if (definedAnnotation == null) {
            throw new AnnotationNotFoundException();
        }
        return definedAnnotation;
    }
}

