/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.conditions.FluentConditions;
import org.fluentlenium.core.conditions.FluentListConditions;
import org.fluentlenium.core.conditions.wait.WaitConditionProxy;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.wait.FluentWaitConditions;
import org.fluentlenium.core.wait.FluentWaitConfiguration;
import org.fluentlenium.core.wait.FluentWaitFunctional;
import org.fluentlenium.core.wait.FluentWaitPageConditions;
import org.fluentlenium.core.wait.FluentWaitWindowConditions;
import org.fluentlenium.core.wait.WaitInterruptedException;
import org.fluentlenium.utils.SupplierOfInstance;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;

public class FluentWait
implements FluentWaitFunctional<FluentControl>,
FluentWaitConditions<FluentWait>,
FluentWaitConfiguration<FluentWait> {
    private final org.openqa.selenium.support.ui.FluentWait<FluentControl> wait;
    private final WebDriver driver;
    private boolean useDefaultException;
    private boolean messageDefined;
    private boolean defaultExceptionsRegistered;
    private boolean ignoreAssertionErrorRegistered;

    public FluentWait(FluentControl control) {
        this.wait = new org.openqa.selenium.support.ui.FluentWait((Object)control);
        this.wait.withTimeout(Duration.ofSeconds(5L));
        this.driver = control.getDriver();
        this.useDefaultException = true;
    }

    @Override
    public org.openqa.selenium.support.ui.FluentWait getWait() {
        return this.wait;
    }

    @Override
    public FluentWait atMost(Duration duration) {
        this.wait.withTimeout(duration);
        return this;
    }

    @Override
    public FluentWait pollingEvery(Duration duration) {
        this.wait.pollingEvery(duration);
        return this;
    }

    @Override
    public FluentWait ignoreAll(Collection<Class<? extends Throwable>> types) {
        this.wait.ignoreAll(types);
        return this;
    }

    @Override
    public FluentWait ignoring(Class<? extends RuntimeException> exceptionType) {
        this.wait.ignoring(exceptionType);
        return this;
    }

    @Override
    public FluentWait ignoring(Class<? extends RuntimeException> firstType, Class<? extends RuntimeException> secondType) {
        this.wait.ignoring(firstType, secondType);
        return this;
    }

    @Override
    public FluentWait withMessage(Supplier<String> message) {
        this.wait.withMessage(message);
        this.messageDefined = true;
        return this;
    }

    @Override
    public FluentWait withNoDefaultsException() {
        this.useDefaultException = false;
        return this;
    }

    private void updateWaitWithDefaultExceptions() {
        if (this.useDefaultException & !this.defaultExceptionsRegistered) {
            this.defaultExceptionsRegistered = true;
            this.wait.ignoring(NoSuchElementException.class);
            this.wait.ignoring(StaleElementReferenceException.class);
        }
    }

    @Override
    public boolean hasMessageDefined() {
        return this.messageDefined;
    }

    @Override
    public void untilPredicate(Predicate<FluentControl> predicate) {
        this.updateWaitWithDefaultExceptions();
        this.wait.until(predicate::test);
    }

    @Override
    public void until(final Supplier<Boolean> booleanSupplier) {
        this.updateWaitWithDefaultExceptions();
        this.wait.until((Function)new Function<Object, Boolean>(){

            @Override
            public Boolean apply(Object input) {
                return (Boolean)booleanSupplier.get();
            }

            public String toString() {
                return booleanSupplier.toString();
            }
        });
    }

    @Override
    public <T> T until(final Function<? super FluentControl, T> function) {
        this.updateWaitWithDefaultExceptions();
        return (T)this.wait.until(new Function<Object, T>(){

            @Override
            public T apply(Object input) {
                return function.apply((FluentControl)input);
            }

            public String toString() {
                return function.toString();
            }
        });
    }

    @Override
    public FluentConditions until(FluentWebElement element) {
        this.updateWaitWithDefaultExceptions();
        return WaitConditionProxy.element(this, "Element " + element.toString(), new SupplierOfInstance<FluentWebElement>(element));
    }

    @Override
    public FluentListConditions until(List<? extends FluentWebElement> elements) {
        this.updateWaitWithDefaultExceptions();
        return WaitConditionProxy.one(this, "Elements " + elements.toString(), () -> elements);
    }

    @Override
    public FluentListConditions untilEach(List<? extends FluentWebElement> elements) {
        this.updateWaitWithDefaultExceptions();
        return WaitConditionProxy.each(this, "Elements " + elements.toString(), () -> elements);
    }

    @Override
    public FluentConditions untilElement(Supplier<? extends FluentWebElement> element) {
        this.updateWaitWithDefaultExceptions();
        return WaitConditionProxy.element(this, "Element " + element, element);
    }

    @Override
    public FluentListConditions untilElements(Supplier<? extends List<? extends FluentWebElement>> elements) {
        this.updateWaitWithDefaultExceptions();
        return WaitConditionProxy.one(this, "Elements " + elements, elements);
    }

    @Override
    public FluentListConditions untilEachElements(Supplier<? extends List<? extends FluentWebElement>> elements) {
        this.updateWaitWithDefaultExceptions();
        return WaitConditionProxy.each(this, "Elements " + elements, elements);
    }

    @Override
    public FluentWaitWindowConditions untilWindow(String windowName) {
        return new FluentWaitWindowConditions(this, windowName);
    }

    @Override
    public FluentWaitPageConditions untilPage() {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitPageConditions(this, this.driver);
    }

    @Override
    public FluentWaitPageConditions untilPage(FluentPage page) {
        this.updateWaitWithDefaultExceptions();
        return new FluentWaitPageConditions(this, this.driver, page);
    }

    @Override
    public FluentWait explicitlyFor(long amount, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(amount);
        }
        catch (InterruptedException e) {
            throw new WaitInterruptedException("Explicit wait was interrupted.", e);
        }
        return this;
    }

    @Override
    public FluentWait untilAsserted(Runnable block) {
        this.updateWaitWithDefaultExceptions();
        if (!this.ignoreAssertionErrorRegistered) {
            this.ignoreAll(Collections.singletonList(AssertionError.class));
            this.ignoreAssertionErrorRegistered = true;
        }
        this.wait.until(control -> {
            block.run();
            return true;
        });
        return this;
    }
}

