/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.inject.FluentInjectControl;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.search.AbstractSearchSupplier;
import org.fluentlenium.core.search.SearchControl;
import org.fluentlenium.core.search.SearchFilter;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class Search
implements SearchControl<FluentWebElement> {
    private final SearchContext searchContext;
    private final Object container;
    private final ComponentInstantiator instantiator;
    private final FluentInjectControl injectControl;

    public Search(SearchContext context, Object container, ComponentInstantiator instantiator, FluentInjectControl injectControl) {
        this.searchContext = context;
        this.container = container;
        this.instantiator = instantiator;
        this.injectControl = injectControl;
    }

    @Override
    public FluentList<FluentWebElement> find(String selector, SearchFilter ... filters) {
        StringBuilder stringBuilder = new StringBuilder(selector);
        final ArrayList<SearchFilter> postFilterSelector = new ArrayList<SearchFilter>();
        if (filters != null && filters.length > 0) {
            for (SearchFilter filter : filters) {
                if (filter.isCssFilterSupported()) {
                    stringBuilder.append(filter.getCssFilter());
                    continue;
                }
                postFilterSelector.add(filter);
            }
        }
        List<WebElement> select = this.selectList(stringBuilder.toString());
        final FluentList<FluentWebElement> fluentList = this.instantiator.asFluentList(select);
        this.injectControl.injectComponent(fluentList, this.container, this.searchContext);
        if (postFilterSelector.isEmpty()) {
            return fluentList;
        }
        List<WebElement> postFilteredElements = LocatorProxies.createWebElementList(new AbstractSearchSupplier(postFilterSelector, select){

            @Override
            public List<WebElement> get() {
                Collection<Object> postFiltered = fluentList;
                for (SearchFilter filter : postFilterSelector) {
                    postFiltered = filter.applyFilter(postFiltered);
                }
                ArrayList<WebElement> webElements = new ArrayList<WebElement>();
                for (FluentWebElement element : postFiltered) {
                    webElements.add(element.getElement());
                }
                return webElements;
            }
        });
        FluentList<FluentWebElement> postFilteredList = this.instantiator.asFluentList(postFilteredElements);
        this.injectControl.injectComponent(postFilteredList, this.container, this.searchContext);
        return postFilteredList;
    }

    private ElementLocator locator(final By by) {
        return new ElementLocator(){

            public WebElement findElement() {
                return Search.this.searchContext.findElement(by);
            }

            public List<WebElement> findElements() {
                return Search.this.searchContext.findElements(by);
            }

            public String toString() {
                return by.toString();
            }
        };
    }

    private List<WebElement> selectList(String cssSelector) {
        return this.selectList(By.cssSelector((String)cssSelector));
    }

    private List<WebElement> selectList(By locator) {
        return LocatorProxies.createWebElementList(this.locator(locator));
    }

    @Override
    public FluentList<FluentWebElement> find(SearchFilter ... filters) {
        if (filters == null || filters.length == 0) {
            throw new IllegalArgumentException("cssSelector or filter is required");
        }
        return this.find("*", filters);
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, final SearchFilter ... filters) {
        List<WebElement> select = this.selectList(locator);
        final FluentList<FluentWebElement> fluentList = this.instantiator.asFluentList(select);
        if (filters.length == 0) {
            return fluentList;
        }
        List<WebElement> postFilteredElements = LocatorProxies.createWebElementList(new AbstractSearchSupplier(Arrays.asList(filters), select){

            @Override
            public List<WebElement> get() {
                Collection<Object> postFiltered = fluentList;
                for (SearchFilter filter : filters) {
                    postFiltered = filter.applyFilter(postFiltered);
                }
                ArrayList<WebElement> webElements = new ArrayList<WebElement>();
                for (FluentWebElement element : postFiltered) {
                    webElements.add(element.getElement());
                }
                return webElements;
            }
        });
        return this.instantiator.asFluentList(postFilteredElements);
    }

    @Override
    public FluentList<FluentWebElement> find(List<WebElement> rawElements) {
        FluentList<FluentWebElement> postFilteredList = this.instantiator.asFluentList(rawElements);
        this.injectControl.injectComponent(postFilteredList, this.container, this.searchContext);
        return postFilteredList;
    }

    @Override
    public FluentWebElement el(WebElement rawElement) {
        return this.find(Collections.singletonList(rawElement)).first();
    }
}

