/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.util.Objects;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.EventListener;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.events.NavigateAllListener;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;

public class EventsSupport
implements EventListener {
    private final EventsRegistry eventsRegistry;

    public EventsSupport(EventsRegistry eventsRegistry) {
        this.eventsRegistry = Objects.requireNonNull(eventsRegistry);
    }

    @Override
    public void beforeNavigateTo(String url, WebDriver driver) {
        this.eventsRegistry.beforeNavigateTo.forEach(listener -> listener.on(url, driver));
        this.eventsRegistry.beforeNavigate.forEach(listener -> listener.on(url, driver, null));
    }

    @Override
    public void afterNavigateTo(String url, WebDriver driver) {
        this.eventsRegistry.afterNavigateTo.forEach(listener -> listener.on(url, driver));
        this.eventsRegistry.afterNavigate.forEach(listener -> listener.on(url, driver, null));
    }

    @Override
    public void beforeNavigateBack(WebDriver driver) {
        this.eventsRegistry.beforeNavigateBack.forEach(listener -> listener.on(driver));
        this.eventsRegistry.beforeNavigate.forEach(listener -> listener.on(null, driver, NavigateAllListener.Direction.BACK));
    }

    @Override
    public void afterNavigateBack(WebDriver driver) {
        this.eventsRegistry.afterNavigateBack.forEach(listener -> listener.on(driver));
        this.eventsRegistry.afterNavigate.forEach(listener -> listener.on(null, driver, NavigateAllListener.Direction.BACK));
    }

    @Override
    public void beforeNavigateForward(WebDriver driver) {
        this.eventsRegistry.beforeNavigateForward.forEach(listener -> listener.on(driver));
        this.eventsRegistry.beforeNavigate.forEach(listener -> listener.on(null, driver, NavigateAllListener.Direction.FORWARD));
    }

    @Override
    public void afterNavigateForward(WebDriver driver) {
        this.eventsRegistry.afterNavigateForward.forEach(listener -> listener.on(driver));
        this.eventsRegistry.afterNavigate.forEach(listener -> listener.on(null, driver, NavigateAllListener.Direction.FORWARD));
    }

    @Override
    public void beforeNavigateRefresh(WebDriver driver) {
        this.eventsRegistry.beforeNavigateRefresh.forEach(listener -> listener.on(driver));
        this.eventsRegistry.beforeNavigate.forEach(listener -> listener.on(null, driver, NavigateAllListener.Direction.REFRESH));
    }

    @Override
    public void afterNavigateRefresh(WebDriver driver) {
        this.eventsRegistry.afterNavigateRefresh.forEach(listener -> listener.on(driver));
        this.eventsRegistry.afterNavigate.forEach(listener -> listener.on(null, driver, NavigateAllListener.Direction.REFRESH));
    }

    @Override
    public void beforeFindBy(By by, FluentWebElement element, WebDriver driver) {
        this.eventsRegistry.beforeFindBy.forEach(listener -> listener.on(by, element, driver));
    }

    @Override
    public void afterFindBy(By by, FluentWebElement element, WebDriver driver) {
        this.eventsRegistry.afterFindBy.forEach(listener -> listener.on(by, element, driver));
    }

    @Override
    public void beforeClickOn(FluentWebElement element, WebDriver driver) {
        this.eventsRegistry.beforeClickOn.forEach(listener -> listener.on(element, driver));
    }

    @Override
    public void afterClickOn(FluentWebElement element, WebDriver driver) {
        this.eventsRegistry.afterClickOn.forEach(listener -> listener.on(element, driver));
    }

    @Override
    public void beforeChangeValueOf(FluentWebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.eventsRegistry.beforeChangeValueOf.forEach(listener -> listener.on(element, driver));
    }

    @Override
    public void afterChangeValueOf(FluentWebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.eventsRegistry.afterChangeValueOf.forEach(listener -> listener.on(element, driver));
    }

    @Override
    public void beforeGetText(FluentWebElement webElement, WebDriver webDriver) {
        this.eventsRegistry.beforeGetText.forEach(listener -> listener.on(webElement, webDriver));
    }

    @Override
    public void afterGetText(FluentWebElement webElement, WebDriver webDriver, String s) {
        this.eventsRegistry.afterGetText.forEach(listener -> listener.on(webElement, webDriver));
    }

    @Override
    public void beforeScript(String script, WebDriver driver) {
        this.eventsRegistry.beforeScript.forEach(listener -> listener.on(script, driver));
    }

    @Override
    public void afterScript(String script, WebDriver driver) {
        this.eventsRegistry.afterScript.forEach(listener -> listener.on(script, driver));
    }

    @Override
    public void onException(Throwable throwable, WebDriver driver) {
        this.eventsRegistry.onException.forEach(listener -> listener.on(throwable, driver));
    }

    @Override
    public void beforeAlertAccept(WebDriver driver) {
        this.eventsRegistry.beforeAlertAccept.forEach(listener -> listener.on(driver));
    }

    @Override
    public void afterAlertAccept(WebDriver driver) {
        this.eventsRegistry.afterAlertAccept.forEach(listener -> listener.on(driver));
    }

    @Override
    public void beforeAlertDismiss(WebDriver driver) {
        this.eventsRegistry.beforeAlertDismiss.forEach(listener -> listener.on(driver));
    }

    @Override
    public void afterAlertDismiss(WebDriver driver) {
        this.eventsRegistry.afterAlertDismiss.forEach(listener -> listener.on(driver));
    }

    @Override
    public void beforeSwitchToWindow(String s, WebDriver webDriver) {
        this.eventsRegistry.beforeSwitchToWindow.forEach(listener -> listener.on(s, webDriver));
    }

    @Override
    public void afterSwitchToWindow(String s, WebDriver webDriver) {
        this.eventsRegistry.afterSwitchToWindow.forEach(listener -> listener.on(s, webDriver));
    }

    @Override
    public <X> void beforeGetScreenshotAs(OutputType<X> outputType) {
        this.eventsRegistry.beforeGetScreenshotAs.forEach(listener -> listener.on(outputType));
    }

    @Override
    public <X> void afterGetScreenshotAs(OutputType<X> outputType, X x) {
        this.eventsRegistry.beforeGetScreenshotAs.forEach(listener -> listener.on(outputType, x));
    }
}

