/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.fluentlenium.core.components.ComponentsAccessor;
import org.fluentlenium.core.components.ComponentsListener;
import org.fluentlenium.core.events.ContainerAnnotationsEventsRegistry;
import org.fluentlenium.core.events.EventsRegistry;
import org.openqa.selenium.WebElement;

public class ComponentsEventsRegistry
implements ComponentsListener {
    private final EventsRegistry registry;
    private final ComponentsAccessor componentsAccessor;
    private final Map<RegistryKey, ContainerAnnotationsEventsRegistry> allRegistries = new IdentityHashMap<RegistryKey, ContainerAnnotationsEventsRegistry>();

    public ComponentsEventsRegistry(EventsRegistry registry, ComponentsAccessor componentsAccessor) {
        this.registry = registry;
        this.componentsAccessor = componentsAccessor;
        this.componentsAccessor.addComponentsListener(this);
    }

    @Override
    public void componentRegistered(WebElement element, Object component) {
        ContainerAnnotationsEventsRegistry containerRegistry = new ContainerAnnotationsEventsRegistry(this.registry, component, element);
        if (containerRegistry.getListenerCount() > 0) {
            this.allRegistries.put(new RegistryKey(element, component), containerRegistry);
        }
    }

    @Override
    public void componentReleased(WebElement element, Object component) {
        ContainerAnnotationsEventsRegistry remove = this.allRegistries.remove(new RegistryKey(element, component));
        if (remove != null) {
            remove.close();
        }
    }

    public void close() {
        Iterator<Map.Entry<RegistryKey, ContainerAnnotationsEventsRegistry>> entries = this.allRegistries.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<RegistryKey, ContainerAnnotationsEventsRegistry> entry = entries.next();
            entry.getValue().close();
            entries.remove();
        }
        this.componentsAccessor.removeComponentsListener(this);
    }

    public static class RegistryKey {
        WebElement element;
        Object component;

        public RegistryKey(WebElement element, Object component) {
            this.element = element;
            this.component = component;
        }
    }
}

