/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.core.events.ListenerContext;
import org.fluentlenium.core.events.ListenerPriority;
import org.fluentlenium.core.events.SwitchToWindowListener;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebDriver;

class AnnotationSwitchToWindowListener
implements SwitchToWindowListener,
ListenerPriority {
    private final Method method;
    private final Object container;
    private final String annotationName;
    private final int priority;

    AnnotationSwitchToWindowListener(ListenerContext listenerContext) {
        this.method = listenerContext.getMethod();
        this.container = listenerContext.getContainer();
        this.annotationName = listenerContext.getAnnotationName();
        this.priority = listenerContext.getPriority();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected Function<Class<?>, Object> getArgsFunction(String s, WebDriver driver) {
        return input -> {
            if (input.isAssignableFrom(String.class)) {
                return s;
            }
            if (input.isAssignableFrom(WebDriver.class)) {
                return driver;
            }
            return null;
        };
    }

    @Override
    public void on(String s, WebDriver driver) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(s, driver), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.container, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

