/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;

public class KeyboardElementActions {
    private final WebDriver driver;
    private final WebElement element;

    public KeyboardElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public KeyboardElementActions(WebDriver driver, FluentWebElement fluentWebElement) {
        this(driver, fluentWebElement.getElement());
    }

    private Actions actions() {
        return new Actions(this.driver);
    }

    @Deprecated
    public Keyboard basic() {
        return ((HasInputDevices)this.driver).getKeyboard();
    }

    public KeyboardElementActions keyDown(Keys theKey) {
        this.loadElementAndPerform(this.actions().keyDown(this.element, (CharSequence)theKey));
        return this;
    }

    public KeyboardElementActions keyUp(Keys theKey) {
        this.loadElementAndPerform(this.actions().keyUp(this.element, (CharSequence)theKey));
        return this;
    }

    public KeyboardElementActions sendKeys(CharSequence ... keysToSend) {
        this.loadElementAndPerform(this.actions().sendKeys(this.element, keysToSend));
        return this;
    }

    private void loadElementAndPerform(Actions action) {
        this.loadElement();
        action.perform();
    }

    private void loadElement() {
        LocatorProxies.now(this.element);
    }
}

