/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import java.util.function.Consumer;
import org.fluentlenium.core.action.BaseFill;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.support.ui.Select;

public class FillSelect<E extends FluentWebElement>
extends BaseFill<E> {
    public FillSelect(FluentList<E> list) {
        super(list);
    }

    public FillSelect(E element) {
        super(element);
    }

    @Override
    protected FluentList<E> getElements() {
        FluentList<FluentWebElement> elements = super.getElements();
        elements.removeIf(next -> next.tagName() == null || !next.tagName().equalsIgnoreCase("select"));
        return elements;
    }

    public FillSelect withIndex(int index) {
        boolean noSuchElement = true;
        for (FluentWebElement element : this.getElements()) {
            Select select = new Select(element.getElement());
            try {
                select.selectByIndex(index);
                noSuchElement = false;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (noSuchElement) {
            throw new NoSuchElementException("No select element found with option index=" + index);
        }
        return this;
    }

    public FillSelect withValue(String value) {
        return this.doSelect(select -> select.selectByValue(value));
    }

    public FillSelect withText(String text) {
        return this.doSelect(select -> select.selectByVisibleText(text));
    }

    private FillSelect doSelect(Consumer<Select> elementSelector) {
        FluentList<E> elements = this.getElements();
        if (elements.isEmpty()) {
            throw new NoSuchElementException("No select element found");
        }
        for (FluentWebElement element : elements) {
            Select select = new Select(element.getElement());
            elementSelector.accept(select);
        }
        return this;
    }
}

