/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.fluentlenium.core.DefaultFluentContainer;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPageControl;
import org.fluentlenium.core.PageUrlCache;
import org.fluentlenium.core.annotation.PageUrl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.inject.Unshadower;
import org.fluentlenium.core.page.ClassAnnotations;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.url.ParsedUrlTemplate;
import org.fluentlenium.core.url.UrlTemplate;
import org.fluentlenium.utils.Preconditions;
import org.fluentlenium.utils.UrlUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;

public class FluentPage
extends DefaultFluentContainer
implements FluentPageControl {
    private final ClassAnnotations classAnnotations = new ClassAnnotations(this.getClass());
    private final PageUrlCache pageUrlCache = new PageUrlCache();

    public FluentPage() {
    }

    public FluentPage(FluentControl control) {
        super(control);
    }

    public ClassAnnotations getClassAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public String getUrl() {
        return Optional.ofNullable(this.getPageUrlAnnotation()).map(pageUrl -> this.getPageUrlValue((PageUrl)pageUrl)).filter(url -> !url.isEmpty()).orElse(null);
    }

    public String getParam(String parameterName) {
        Preconditions.checkArgumentBlank(parameterName, "The parameter name to query should not be blank.");
        String url = this.url();
        if (url.startsWith("file:///")) {
            try {
                url = new URL(this.url()).toURI().toString();
            }
            catch (MalformedURLException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if (!url.equals(this.pageUrlCache.getUrl())) {
            this.pageUrlCache.cache(url, this.parseUrl(url).parameters());
        }
        return this.pageUrlCache.getParameter(parameterName);
    }

    @Override
    public String getUrl(Object ... parameters) {
        return Optional.ofNullable(this.getUrl()).map(url -> this.toRenderedUrlTemplate((String)url, parameters)).orElse(null);
    }

    @Override
    public void isAt() {
        By by = this.classAnnotations.buildBy();
        if (by != null) {
            this.isAtUsingSelector(by);
        }
        this.isAtUrl(this.getUrl());
    }

    @Override
    public void isAt(Object ... parameters) {
        this.isAtUrl(this.getUrl(parameters));
    }

    public void isAtUsingUrl(String urlTemplate) {
        String url;
        UrlTemplate template;
        ParsedUrlTemplate parse;
        if (!this.isLocalFile(this.getPageUrlAnnotation()) && !(parse = (template = new UrlTemplate(urlTemplate)).parse(url = this.url())).matches()) {
            throw new AssertionError((Object)String.format("Current URL [%s] doesn't match expected Page URL [%s]", url, urlTemplate));
        }
    }

    public void isAtUsingSelector(By by) {
        try {
            ((FluentWebElement)this.$(by, new SearchFilter[0]).first()).now();
        }
        catch (NoSuchElementException | StaleElementReferenceException | TimeoutException e) {
            throw new AssertionError("@FindBy element not found for page " + this.getClass().getName(), e);
        }
    }

    @Override
    public <P extends FluentPage> P go() {
        return this.navigateTo(this.getUrl());
    }

    @Override
    public <P extends FluentPage> P go(Object ... params) {
        return this.navigateTo(this.getUrl(params));
    }

    @Override
    public ParsedUrlTemplate parseUrl() {
        return this.parseUrl(this.url());
    }

    public void verifyIsLoaded() {
    }

    public void unshadowAllFields() {
        if (this.getDriver() != null) {
            new Unshadower(this.getDriver(), this).unshadowAllAnnotatedFields();
        }
    }

    @Override
    public ParsedUrlTemplate parseUrl(String url) {
        return Optional.ofNullable(this.getUrl()).map(templateUrl -> new UrlTemplate((String)templateUrl).parse(url)).orElseThrow(() -> new IllegalStateException("An URL should be defined on the page. Use @PageUrl annotation or override getUrl() method."));
    }

    private String toRenderedUrlTemplate(String url, Object[] parameters) {
        UrlTemplate template = new UrlTemplate(url);
        for (Object parameter : parameters) {
            template.add(parameter == null ? null : String.valueOf(parameter));
        }
        return template.render();
    }

    private void isAtUrl(String url) {
        if (url != null) {
            this.isAtUsingUrl(url);
        }
    }

    private String getPageUrlValue(PageUrl pageUrl) {
        return (this.isLocalFile(pageUrl) ? UrlUtils.getAbsoluteUrlFromFile(pageUrl.file()) : "") + pageUrl.value();
    }

    private boolean isLocalFile(PageUrl pageUrl) {
        return pageUrl != null && !pageUrl.file().isEmpty();
    }

    private PageUrl getPageUrlAnnotation() {
        return this.getClass().isAnnotationPresent(PageUrl.class) ? this.getClass().getAnnotation(PageUrl.class) : null;
    }

    private <P extends FluentPage> P navigateTo(String url) {
        Preconditions.checkState(url, "An URL should be defined on the page. Use @PageUrl annotation or override getUrl() method.");
        this.goTo(url);
        return (P)this;
    }
}

