/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.util.Objects;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.wait.FluentWait;

public class FluentDriverWait {
    private final Configuration configuration;

    public FluentDriverWait(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public FluentWait await(FluentControl control) {
        FluentWait fluentWait = new FluentWait(control);
        this.configureWithAwaitAtMost(fluentWait);
        this.configureWithPollingEvery(fluentWait);
        return fluentWait;
    }

    private void configureWithAwaitAtMost(FluentWait fluentWait) {
        Long atMost = this.configuration.getAwaitAtMost();
        if (atMost != null) {
            fluentWait.atMost(atMost);
        }
    }

    private void configureWithPollingEvery(FluentWait fluentWait) {
        Long pollingEvery = this.configuration.getAwaitPollingEvery();
        if (pollingEvery != null) {
            fluentWait.pollingEvery(pollingEvery);
        }
    }
}

