/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.FactoryNames;
import org.fluentlenium.configuration.ReflectiveFactory;
import org.fluentlenium.configuration.WebDriverFactory;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ReflectiveWebDriverFactory
implements WebDriverFactory,
ReflectiveFactory,
FactoryNames {
    protected String name;
    protected Object[] args;
    protected String webDriverClassName;
    protected Class<? extends WebDriver> webDriverClass;
    protected boolean available;

    public ReflectiveWebDriverFactory(String name, String webDriverClassName, Object ... args) {
        this.name = name;
        this.webDriverClassName = webDriverClassName;
        this.args = args;
        try {
            this.webDriverClass = Class.forName(webDriverClassName);
            this.available = WebDriver.class.isAssignableFrom(this.webDriverClass);
        }
        catch (ClassNotFoundException e) {
            this.available = false;
        }
    }

    public ReflectiveWebDriverFactory(String name, Class<? extends WebDriver> webDriverClass, Object ... args) {
        this.name = name;
        this.webDriverClass = webDriverClass;
        this.args = args;
        this.webDriverClassName = webDriverClass.getName();
        this.available = WebDriver.class.isAssignableFrom(this.webDriverClass);
    }

    public Class<? extends WebDriver> getWebDriverClass() {
        return this.webDriverClass;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    protected DesiredCapabilities newDefaultCapabilities() {
        return null;
    }

    @Override
    public WebDriver newWebDriver(Capabilities capabilities, ConfigurationProperties configuration) {
        if (!this.available) {
            throw new ConfigurationException("WebDriver " + this.webDriverClassName + " is not available.");
        }
        try {
            DesiredCapabilities defaultCapabilities = this.newDefaultCapabilities();
            if (defaultCapabilities != null) {
                defaultCapabilities.merge(capabilities);
                capabilities = defaultCapabilities;
            }
            if (capabilities != null && !capabilities.asMap().isEmpty()) {
                ArrayList<Object> argsList = new ArrayList<Object>(Arrays.asList(this.args));
                argsList.add(0, capabilities);
                try {
                    return this.newInstance(this.webDriverClass, configuration, argsList.toArray());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return this.newInstance(this.webDriverClass, configuration, this.args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("Can't create new WebDriver instance", e);
        }
    }

    protected WebDriver newInstance(Class<? extends WebDriver> webDriverClass, ConfigurationProperties configuration, Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return ReflectionUtils.newInstance(webDriverClass, args);
    }

    @Override
    public String[] getNames() {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.name));
        if (this.webDriverClass != null) {
            names.add(this.webDriverClass.getName());
            names.add(this.webDriverClass.getSimpleName());
        }
        return names.toArray(new String[names.size()]);
    }
}

