/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.fluentlenium.configuration.CapabilitiesFactory;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.FactoryNames;
import org.fluentlenium.configuration.ReflectiveFactory;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ReflectiveCapabilitiesFactory
implements CapabilitiesFactory,
FactoryNames,
ReflectiveFactory {
    private final String name;
    private final Object[] args;
    private final String capabilitiesClassName;
    private Class<? extends Capabilities> capabilitiesClass;
    private boolean available;

    public ReflectiveCapabilitiesFactory(String name, String capabilitiesClassName, Object ... args) {
        this.name = name;
        this.capabilitiesClassName = capabilitiesClassName;
        this.args = args;
        try {
            this.capabilitiesClass = Class.forName(capabilitiesClassName);
            this.available = Capabilities.class.isAssignableFrom(this.capabilitiesClass);
        }
        catch (ClassNotFoundException e) {
            this.available = false;
        }
    }

    public ReflectiveCapabilitiesFactory(String name, Class<? extends Capabilities> capabilitiesClass, Object ... args) {
        this.name = name;
        this.capabilitiesClass = capabilitiesClass;
        this.args = args;
        this.capabilitiesClassName = capabilitiesClass.getName();
        this.available = Capabilities.class.isAssignableFrom(this.capabilitiesClass);
    }

    public Class<? extends Capabilities> getCapabilitiesClass() {
        return this.capabilitiesClass;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    protected DesiredCapabilities newDefaultCapabilities() {
        return null;
    }

    @Override
    public Capabilities newCapabilities(ConfigurationProperties configuration) {
        if (!this.available) {
            throw new ConfigurationException("Capabilities " + this.capabilitiesClassName + " is not available.");
        }
        try {
            return ReflectionUtils.newInstance(this.capabilitiesClass, this.args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigurationException("Can't create new Capabilities instance", e);
        }
    }

    @Override
    public String[] getNames() {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.name));
        if (this.capabilitiesClass != null) {
            names.add(this.capabilitiesClass.getName());
            names.add(this.capabilitiesClass.getSimpleName());
        }
        return names.toArray(new String[names.size()]);
    }
}

