/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.InvocationTargetException;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.configuration.ConfigurationDefaults;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.DefaultConfigurationFactory;
import org.fluentlenium.utils.ReflectionUtils;

public final class ConfigurationFactoryProvider {
    private static final ConfigurationFactory BOOTSTRAP_FACTORY = new DefaultConfigurationFactory();

    private ConfigurationFactoryProvider() {
    }

    public static ConfigurationFactory getConfigurationFactory(Class<?> container) {
        Configuration configuration = BOOTSTRAP_FACTORY.newConfiguration(container, new ConfigurationDefaults());
        Class<? extends ConfigurationFactory> configurationFactoryClass = configuration.getConfigurationFactory();
        if (configurationFactoryClass != null) {
            try {
                return ReflectionUtils.newInstance(configurationFactoryClass, new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigurationException("Can't initialize ConfigurationFactory " + configurationFactoryClass.getName(), e);
            }
        }
        return BOOTSTRAP_FACTORY;
    }

    public static Configuration newConfiguration(Class<?> container) {
        ConfigurationFactory configurationFactory = ConfigurationFactoryProvider.getConfigurationFactory(container);
        Configuration configuration = configurationFactory.newConfiguration(container, new ConfigurationDefaults());
        if (configuration.getConfigurationDefaults() != null && configuration.getConfigurationDefaults() != ConfigurationDefaults.class) {
            ConfigurationProperties configurationDefaults;
            try {
                configurationDefaults = ReflectionUtils.newInstance(configuration.getConfigurationDefaults(), new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConfigurationException("Can't initialize ConfigurationDefaults:" + configuration.getConfigurationDefaults(), e);
            }
            configuration = configurationFactory.newConfiguration(container, configurationDefaults);
        }
        return configuration;
    }
}

