/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.atteo.classindex.ClassIndex;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.DefaultFactory;
import org.fluentlenium.configuration.Factory;
import org.fluentlenium.configuration.FactoryName;
import org.fluentlenium.configuration.FactoryNames;
import org.fluentlenium.configuration.FactoryPriority;
import org.fluentlenium.configuration.IndexIgnore;
import org.fluentlenium.configuration.ReflectiveFactory;

public abstract class AbstractFactoryRegistryImpl<T extends Factory, R extends ReflectiveFactory> {
    protected final Class<T> factoryType;
    protected final Class<R> reflectiveFactoryType;
    protected Map<String, T> factories = new LinkedHashMap<String, T>();

    public AbstractFactoryRegistryImpl(Class<T> factoryType, Class<R> reflectiveFactoryType) {
        this.factoryType = factoryType;
        this.reflectiveFactoryType = reflectiveFactoryType;
        Iterable factoryClasses = ClassIndex.getSubclasses(factoryType);
        for (Class factoryClass : factoryClasses) {
            Factory factory;
            if (factoryClass.isAnnotationPresent(IndexIgnore.class) || !this.noInterfaceIsAnnotatedAsIndexIgnore(factoryClass) || !this.isNotAbstractAndPublic(factoryClass)) continue;
            try {
                factory = (Factory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(factoryClass + " should have a public default constructor.", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new ConfigurationException(factoryClass + " can't be instantiated.", e);
            }
            this.register(factory);
        }
    }

    private boolean noInterfaceIsAnnotatedAsIndexIgnore(Class<? extends T> factoryClass) {
        return Arrays.stream(factoryClass.getInterfaces()).noneMatch(iface -> iface.isAnnotationPresent(IndexIgnore.class));
    }

    private boolean isNotAbstractAndPublic(Class<? extends T> factoryClass) {
        return !Modifier.isAbstract(factoryClass.getModifiers()) && Modifier.isPublic(factoryClass.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDefault() {
        ArrayList<T> factoriesList;
        AbstractFactoryRegistryImpl abstractFactoryRegistryImpl = this;
        synchronized (abstractFactoryRegistryImpl) {
            factoriesList = new ArrayList<T>(this.factories.values());
        }
        factoriesList.sort((factory1, factory2) -> Integer.compare(this.getPriority(factory2), this.getPriority(factory1)));
        ArrayList filteredFactories = new ArrayList();
        factoriesList.stream().filter(factory -> !(factory instanceof ReflectiveFactory) || this.isActiveReflectiveFactory(factory)).forEach(filteredFactories::add);
        return (T)this.getDefault(filteredFactories);
    }

    private int getPriority(T factory1) {
        FactoryPriority annotation1 = factory1.getClass().getAnnotation(FactoryPriority.class);
        return annotation1 == null ? 0 : annotation1.value();
    }

    private boolean isActiveReflectiveFactory(T factory) {
        return factory instanceof ReflectiveFactory && ((ReflectiveFactory)factory).isAvailable();
    }

    protected abstract T getDefault(List<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String name) {
        if (name != null) {
            AbstractFactoryRegistryImpl abstractFactoryRegistryImpl = this;
            synchronized (abstractFactoryRegistryImpl) {
                Factory factory = (Factory)this.factories.get(name);
                if (factory == null) {
                    R reflectiveFactory = this.newReflectiveInstance(name);
                    if (reflectiveFactory.isAvailable()) {
                        this.factories.put(name, reflectiveFactory);
                        factory = reflectiveFactory;
                    } else {
                        this.handleNoFactoryAvailable(name);
                    }
                }
                return (T)factory;
            }
        }
        return this.getDefault();
    }

    protected abstract void handleNoFactoryAvailable(String var1);

    protected abstract R newReflectiveInstance(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(T factory) {
        ArrayList<String> names = new ArrayList<String>();
        FactoryName annotation = factory.getClass().getAnnotation(FactoryName.class);
        Optional.ofNullable(annotation).map(FactoryName::value).ifPresent(names::add);
        if (factory instanceof FactoryNames) {
            names.addAll(Arrays.asList(((FactoryNames)factory).getNames()));
        }
        if (names.isEmpty()) {
            throw new ConfigurationException("Factory " + factory.getClass().getName() + " has no name defined. Use @FactoryName annotation or implement FactoryNames.");
        }
        AbstractFactoryRegistryImpl abstractFactoryRegistryImpl = this;
        synchronized (abstractFactoryRegistryImpl) {
            this.registerImpl(names, factory);
        }
    }

    private void registerImpl(List<String> names, T factory) {
        boolean registered = false;
        for (String name : names) {
            if (!registered) {
                Factory existingFactory;
                if (this.factories.containsKey(name) && !(existingFactory = (Factory)this.factories.get(name)).getClass().isAnnotationPresent(DefaultFactory.class)) {
                    throw new ConfigurationException("A factory is already registered with this name: " + name + " (" + this.factories.get(name) + ")");
                }
                this.factories.put(name, factory);
                registered = true;
            }
            if (this.factories.containsKey(name)) continue;
            this.factories.put(name, factory);
        }
    }
}

