/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.sharedwebdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.sharedwebdriver.ClassDriver;
import org.fluentlenium.adapter.sharedwebdriver.FluentLeniumDriver;
import org.fluentlenium.adapter.sharedwebdriver.JvmDriver;
import org.fluentlenium.adapter.sharedwebdriver.MethodDriver;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriverContainer;
import org.fluentlenium.adapter.sharedwebdriver.ThreadDriver;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.WebDrivers;
import org.fluentlenium.utils.ExecutorServiceUtil;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;

class SharedWebdriverSingletonImpl {
    private final ClassDriver classDriverImpl = new ClassDriver();
    private final JvmDriver jvmDriverImpl = new JvmDriver();
    private final ThreadDriver threadDriverImpl = new ThreadDriver();
    private final MethodDriver methodDriverImpl = new MethodDriver();
    private final Map<ConfigurationProperties.DriverLifecycle, FluentLeniumDriver> drivers = this.initDrivers();

    SharedWebdriverSingletonImpl() {
    }

    private Map<ConfigurationProperties.DriverLifecycle, FluentLeniumDriver> initDrivers() {
        HashMap<ConfigurationProperties.DriverLifecycle, FluentLeniumDriver> lifecycleDrivers = new HashMap<ConfigurationProperties.DriverLifecycle, FluentLeniumDriver>();
        lifecycleDrivers.put(ConfigurationProperties.DriverLifecycle.JVM, this.jvmDriverImpl);
        lifecycleDrivers.put(ConfigurationProperties.DriverLifecycle.THREAD, this.threadDriverImpl);
        lifecycleDrivers.put(ConfigurationProperties.DriverLifecycle.CLASS, this.classDriverImpl);
        lifecycleDrivers.put(ConfigurationProperties.DriverLifecycle.METHOD, this.methodDriverImpl);
        lifecycleDrivers.put(ConfigurationProperties.DriverLifecycle.DEFAULT, this.methodDriverImpl);
        return lifecycleDrivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedWebDriver getOrCreateDriver(Supplier<WebDriver> webDriverFactory, SharedMutator.EffectiveParameters<?> parameters) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            return Optional.ofNullable(this.getDriver(parameters)).orElseGet(() -> this.createAndRegisterNewDriver(webDriverFactory, parameters));
        }
    }

    private SharedWebDriver createAndRegisterNewDriver(Supplier<WebDriver> webDriverFactory, SharedMutator.EffectiveParameters<?> parameters) {
        SharedWebDriver driver = this.createDriver(webDriverFactory, parameters);
        this.registerDriver(driver);
        return driver;
    }

    private SharedWebDriver createDriver(Supplier<WebDriver> webDriverFactory, SharedMutator.EffectiveParameters<?> parameters) {
        WebDriver webDriver = webDriverFactory.get();
        return new SharedWebDriver(webDriver, parameters.getTestClass(), parameters.getTestName(), parameters.getDriverLifecycle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDriver(SharedWebDriver driver) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            this.drivers.get((Object)driver.getDriverLifecycle()).addDriver(driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedWebDriver getDriver(SharedMutator.EffectiveParameters<?> parameters) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            switch (parameters.getDriverLifecycle()) {
                case JVM: {
                    return this.jvmDriverImpl.getDriver();
                }
                case CLASS: {
                    return this.classDriverImpl.getDriver(parameters.getTestClass());
                }
                case THREAD: {
                    return this.threadDriverImpl.getDriver(parameters.getTestClass(), parameters.getTestName(), Thread.currentThread().getId());
                }
            }
            return this.methodDriverImpl.getDriver(parameters.getTestClass(), parameters.getTestName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit(SharedWebDriver driver) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            this.drivers.get((Object)driver.getDriverLifecycle()).quitDriver(driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SharedWebDriver> getAllDrivers() {
        ArrayList<SharedWebDriver> allDrivers = new ArrayList<SharedWebDriver>();
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            Optional.ofNullable(this.jvmDriverImpl.getDriver()).ifPresent(allDrivers::add);
            allDrivers.addAll(this.classDriverImpl.getClassDrivers().values());
            allDrivers.addAll(this.threadDriverImpl.getThreadDrivers().values());
            allDrivers.addAll(this.methodDriverImpl.getMethodDrivers().values());
        }
        return Collections.unmodifiableList(allDrivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SharedWebDriver> getTestClassDrivers(Class<?> testClass) {
        ArrayList<SharedWebDriver> testClassDrivers = new ArrayList<SharedWebDriver>();
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            Optional.ofNullable(this.classDriverImpl.getClassDrivers().get(testClass)).ifPresent(testClassDrivers::add);
            testClassDrivers.addAll(this.getDrivers(testClass, this.methodDriverImpl.getMethodDrivers()));
            testClassDrivers.addAll(this.getDrivers(testClass, this.threadDriverImpl.getThreadDrivers()));
            return Collections.unmodifiableList(testClassDrivers);
        }
    }

    private List<SharedWebDriver> getDrivers(Class<?> testClass, Map<?, SharedWebDriver> webDrivers) {
        ArrayList<SharedWebDriver> sharedDrivers = new ArrayList<SharedWebDriver>();
        for (SharedWebDriver testDriver : webDrivers.values()) {
            if (testDriver.getTestClass() != testClass) continue;
            sharedDrivers.add(testDriver);
        }
        return sharedDrivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quitAll() {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            Optional.ofNullable(this.jvmDriverImpl.getDriver()).ifPresent(this.jvmDriverImpl::quitDriver);
            this.quitAllDrivers(this.classDriverImpl.getClassDrivers());
            this.quitAllDrivers(this.methodDriverImpl.getMethodDrivers());
            this.quitAllDrivers(this.threadDriverImpl.getThreadDrivers());
        }
    }

    private void quitAllDrivers(Map<?, SharedWebDriver> driverType) {
        Iterator<SharedWebDriver> testThreadDriversIterator = driverType.values().iterator();
        while (testThreadDriversIterator.hasNext()) {
            testThreadDriversIterator.next().getDriver().quit();
            testThreadDriversIterator.remove();
        }
    }

    public SharedWebDriver getSharedWebDriver(SharedMutator.EffectiveParameters<?> parameters, ExecutorService webDriverExecutor, Supplier<WebDriver> webDriver, Configuration configuration) throws ExecutionException, InterruptedException {
        SharedWebDriver sharedWebDriver = null;
        ExecutorService executorService = ExecutorServiceUtil.getExecutor(webDriverExecutor);
        Integer browserTimeoutRetries = configuration.getBrowserTimeoutRetries();
        for (int retryCount = 0; retryCount < browserTimeoutRetries; ++retryCount) {
            Future<SharedWebDriver> futureWebDriver = this.createDriver(parameters, executorService, webDriver);
            ExecutorServiceUtil.shutDownExecutor(executorService, configuration.getBrowserTimeout());
            try {
                sharedWebDriver = futureWebDriver.get();
            }
            catch (InterruptedException | ExecutionException e) {
                executorService.shutdownNow();
                throw e;
            }
            if (sharedWebDriver != null) break;
        }
        return sharedWebDriver;
    }

    private Future<SharedWebDriver> createDriver(SharedMutator.EffectiveParameters<?> parameters, ExecutorService executorService, Supplier<WebDriver> newWebDriver) {
        return executorService.submit(() -> SharedWebDriverContainer.INSTANCE.getOrCreateDriver(newWebDriver, parameters));
    }

    public WebDriver newWebDriver(String name, Capabilities capabilities, Configuration configuration) {
        WebDriver webDriver = WebDrivers.INSTANCE.newWebDriver(name, capabilities, configuration);
        if (Boolean.TRUE.equals(configuration.getEventsEnabled())) {
            webDriver = new EventFiringWebDriver(webDriver);
        }
        return webDriver;
    }
}

