/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.TriConsumer;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriverContainer;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.utils.ExceptionUtil;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public final class TestRunnerCommon {
    private TestRunnerCommon() {
    }

    public static void quitMethodAndThreadDrivers(ConfigurationProperties.DriverLifecycle driverLifecycle, SharedWebDriver sharedWebDriver) {
        block3: {
            block2: {
                if (driverLifecycle == ConfigurationProperties.DriverLifecycle.METHOD) break block2;
                if (driverLifecycle != ConfigurationProperties.DriverLifecycle.THREAD) break block3;
            }
            Optional.ofNullable(sharedWebDriver).ifPresent(SharedWebDriverContainer.INSTANCE::quit);
        }
    }

    public static void deleteCookies(SharedWebDriver sharedWebDriver, Configuration configuration) {
        if (configuration.getDeleteCookies().booleanValue()) {
            Optional.ofNullable(sharedWebDriver).ifPresent(shared -> shared.getDriver().manage().deleteAllCookies());
        }
    }

    public static SharedWebDriver getTestDriver(Class<?> testClass, String testName, Supplier<WebDriver> webDriver, TriConsumer<Throwable, Class<?>, String> failed, Configuration configuration, SharedMutator.EffectiveParameters<?> parameters) {
        SharedWebDriver sharedWebDriver;
        try {
            sharedWebDriver = SharedWebDriverContainer.INSTANCE.getSharedWebDriver(parameters, null, webDriver, configuration);
        }
        catch (InterruptedException | ExecutionException e) {
            failed.accept(null, testClass, testName);
            String causeMessage = ExceptionUtil.getCauseMessage(e);
            throw new WebDriverException(String.format("Browser failed to start, test [ %s ] execution interrupted.%s", testName, TestRunnerCommon.printCauseMessage(causeMessage)), (Throwable)e);
        }
        return sharedWebDriver;
    }

    private static String printCauseMessage(String causeMessage) {
        if (StringUtils.isEmpty((CharSequence)causeMessage)) {
            return "";
        }
        return String.format("\nCaused by: [ %s]", causeMessage);
    }

    public static void doHtmlDump(Class<?> testClass, String testName, FluentControl fluentControl, Configuration configuration) {
        try {
            if (configuration.getHtmlDumpMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && fluentControl.getDriver() != null) {
                fluentControl.takeHtmlDump(String.format("%s_%s.html", testClass.getSimpleName(), testName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void doScreenshot(Class<?> testClass, String testName, FluentControl fluentControl, Configuration configuration) {
        try {
            if (configuration.getScreenshotMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && fluentControl.canTakeScreenShot()) {
                fluentControl.takeScreenshot(String.format("%s_%s.png", testClass.getSimpleName(), testName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

