/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import java.util.Optional;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriverContainer;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentDriver;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.ContainerFluentControl;
import org.openqa.selenium.WebDriver;

public interface IFluentAdapter
extends FluentControl {
    default public boolean isFluentControlAvailable() {
        return this.getControlContainer().getFluentControl() != null;
    }

    default public FluentControl setFluentControl(ContainerFluentControl fluentControl) {
        this.getControlContainer().setFluentControl(fluentControl);
        return this.getControlContainer().getFluentControl();
    }

    default public FluentControl initFluent(WebDriver webDriver, Object container) {
        if (webDriver == null) {
            this.releaseFluent();
            return null;
        }
        if (this.getFluentControl() != null) {
            if (this.getFluentControl().getDriver() == webDriver) {
                return null;
            }
            if (this.getFluentControl().getDriver() != null) {
                throw new IllegalStateException("Trying to init a WebDriver, but another one is still running");
            }
        }
        ContainerFluentControl adapterFluentControl = new ContainerFluentControl(new FluentDriver(webDriver, this, this));
        this.setFluentControl(adapterFluentControl);
        ContainerContext context = adapterFluentControl.inject(container);
        adapterFluentControl.setContext(context);
        return this.getFluentControl();
    }

    default public FluentControl initFluent(WebDriver webDriver) {
        return this.initFluent(webDriver, this);
    }

    @Override
    default public ContainerFluentControl getFluentControl() {
        FluentControlContainer fluentControlContainer = this.getControlContainer();
        if (fluentControlContainer == null) {
            throw new IllegalStateException("FluentControl is not initialized, WebDriver or Configuration issue");
        }
        return (ContainerFluentControl)fluentControlContainer.getFluentControl();
    }

    default public boolean releaseFluent() {
        if (this.getFluentControl() != null) {
            ((FluentDriver)this.getFluentControl().getAdapterControl()).releaseFluent();
            this.setFluentControl(null);
            return true;
        }
        return false;
    }

    default public WebDriver newWebDriver() {
        return SharedWebDriverContainer.INSTANCE.newWebDriver(this.getWebDriver(), this.getCapabilities(), this.getConfiguration());
    }

    @Override
    default public WebDriver getDriver() {
        try {
            return Optional.ofNullable(this.getFluentControl().getDriver()).orElse(null);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }
}

