/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.common.engine.impl.util.io.UrlStreamSource;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.io.ResourceStreamSource;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.json.converter.EventJsonConverter;
import org.flowable.eventregistry.model.EventModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDefinitionParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(EventDefinitionParse.class);
    protected String name;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected EventModel eventModel;
    protected EventDeploymentEntity deployment;
    protected List<EventDefinitionEntity> eventDefinitions = new ArrayList<EventDefinitionEntity>();

    public EventDefinitionParse deployment(EventDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public EventDefinitionParse execute(EventRegistryEngineConfiguration eventEngineConfig) {
        String encoding = eventEngineConfig.getXmlEncoding();
        EventJsonConverter converter = eventEngineConfig.getEventJsonConverter();
        try (InputStreamReader in = this.newInputStreamReaderForSource(encoding);){
            String eventJson = IOUtils.toString((Reader)in);
            this.eventModel = converter.convertToEventModel(eventJson);
            if (this.eventModel != null && this.eventModel.getKey() != null) {
                EventDefinitionEntity eventDefinitionEntity = (EventDefinitionEntity)eventEngineConfig.getEventDefinitionEntityManager().create();
                eventDefinitionEntity.setKey(this.eventModel.getKey());
                eventDefinitionEntity.setName(this.eventModel.getName());
                eventDefinitionEntity.setResourceName(this.name);
                eventDefinitionEntity.setDeploymentId(this.deployment.getId());
                this.eventDefinitions.add(eventDefinitionEntity);
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing event definition JSON", (Throwable)e);
        }
        return this;
    }

    private InputStreamReader newInputStreamReaderForSource(String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new InputStreamReader(this.streamSource.getInputStream(), encoding);
        }
        return new InputStreamReader(this.streamSource.getInputStream());
    }

    public EventDefinitionParse name(String name) {
        this.name = name;
        return this;
    }

    public EventDefinitionParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource((StreamSource)new InputStreamSource(inputStream));
        return this;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public EventDefinitionParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public EventDefinitionParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource((StreamSource)new UrlStreamSource(url));
        return this;
    }

    public EventDefinitionParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("malformed url: " + url, (Throwable)e);
        }
    }

    public EventDefinitionParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public EventDefinitionParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource((StreamSource)new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new FlowableException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public List<EventDefinitionEntity> getEventDefinitions() {
        return this.eventDefinitions;
    }

    public EventDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(EventDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public EventModel getEventModel() {
        return this.eventModel;
    }

    public void setEventModel(EventModel eventModel) {
        this.eventModel = eventModel;
    }
}

