/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventregistry.api.OutboundEventSerializer;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;

public class EventPayloadToJsonStringSerializer
implements OutboundEventSerializer {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public String serialize(EventInstance eventInstance) {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        Collection payloadInstances = eventInstance.getPayloadInstances();
        for (EventPayloadInstance payloadInstance : payloadInstances) {
            String definitionType = payloadInstance.getDefinitionType();
            Object payloadInstanceValue = payloadInstance.getValue();
            if (payloadInstanceValue != null) {
                if ("string".equals(definitionType)) {
                    objectNode.put(payloadInstance.getDefinitionName(), payloadInstanceValue.toString());
                    continue;
                }
                if ("double".equals(definitionType)) {
                    if (payloadInstanceValue instanceof Number) {
                        objectNode.put(payloadInstance.getDefinitionName(), ((Number)payloadInstanceValue).doubleValue());
                        continue;
                    }
                    if (payloadInstanceValue instanceof String) {
                        objectNode.put(payloadInstance.getDefinitionName(), Double.valueOf((String)payloadInstanceValue));
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Cannot convert event payload " + payloadInstanceValue + " to type 'double'");
                }
                if ("integer".equals(definitionType)) {
                    if (payloadInstanceValue instanceof Number) {
                        objectNode.put(payloadInstance.getDefinitionName(), ((Number)payloadInstanceValue).intValue());
                        continue;
                    }
                    if (payloadInstanceValue instanceof String) {
                        objectNode.put(payloadInstance.getDefinitionName(), Integer.valueOf((String)payloadInstanceValue));
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Cannot convert event payload " + payloadInstanceValue + " to type 'integer'");
                }
                if ("long".equals(definitionType)) {
                    if (payloadInstanceValue instanceof Number) {
                        objectNode.put(payloadInstance.getDefinitionName(), ((Number)payloadInstanceValue).longValue());
                        continue;
                    }
                    if (payloadInstanceValue instanceof String) {
                        objectNode.put(payloadInstance.getDefinitionName(), Long.valueOf((String)payloadInstanceValue));
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Cannot convert event payload " + payloadInstanceValue + " to type 'long'");
                }
                if ("boolean".equals(definitionType)) {
                    if (payloadInstanceValue instanceof Boolean) {
                        objectNode.put(payloadInstance.getDefinitionName(), (Boolean)payloadInstanceValue);
                        continue;
                    }
                    if (payloadInstanceValue instanceof String) {
                        objectNode.put(payloadInstance.getDefinitionName(), Boolean.valueOf((String)payloadInstanceValue));
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Cannot convert event payload " + payloadInstanceValue + " to type 'boolean'");
                }
                if ("json".equals(definitionType)) {
                    if (payloadInstanceValue instanceof JsonNode) {
                        objectNode.set(payloadInstance.getDefinitionName(), (JsonNode)payloadInstanceValue);
                        continue;
                    }
                    if (payloadInstanceValue instanceof String) {
                        JsonNode jsonNode = null;
                        try {
                            jsonNode = this.objectMapper.readTree((String)payloadInstanceValue);
                        }
                        catch (JsonProcessingException e) {
                            throw new FlowableIllegalArgumentException("Could not read json event payload", (Throwable)e);
                        }
                        objectNode.set(payloadInstance.getDefinitionName(), jsonNode);
                        continue;
                    }
                    throw new FlowableIllegalArgumentException("Cannot convert event payload " + payloadInstanceValue + " to type 'json'");
                }
                throw new FlowableIllegalArgumentException("Unsupported event payload instance type: " + definitionType);
            }
            objectNode.putNull(payloadInstance.getDefinitionName());
        }
        try {
            return this.objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            throw new FlowableException("Could not serialize event to json string", (Throwable)e);
        }
    }
}

