/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import java.sql.SQLException;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrDbRetryInterceptor
extends AbstractCommandInterceptor {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected int nrRetries = 3;
    protected int waitTime = 50;
    protected int waitTimeIncrease = 5;

    @Override
    public <T> T execute(CommandConfig config, Command<T> command, CommandExecutor commandExecutor) {
        long waitTime = this.waitTime;
        int failedAttempts = 0;
        while (true) {
            if (failedAttempts > 0) {
                this.LOGGER.info("Waiting for {}ms before retrying the command.", (Object)waitTime);
                this.waitBeforeRetry(waitTime);
                waitTime *= (long)this.waitTimeIncrease;
            }
            try {
                return this.next.execute(config, command, commandExecutor);
            }
            catch (Exception e) {
                if (this.isTransactionRetryException(e)) {
                    this.LOGGER.debug("Exception caught. Retrying.", (Throwable)e);
                    if (failedAttempts >= this.nrRetries) {
                        throw e;
                    }
                } else {
                    throw e;
                }
                if (++failedAttempts <= this.nrRetries) continue;
                return null;
            }
            break;
        }
    }

    protected void waitBeforeRetry(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            this.LOGGER.debug("Interrupted while waiting for a retry.");
        }
    }

    protected boolean isTransactionRetryException(Throwable exception) {
        SQLException sqlException;
        if (exception instanceof SQLException && ((sqlException = (SQLException)exception).getErrorCode() == 40001 || sqlException.getMessage() != null && sqlException.getMessage().contains("retry txn"))) {
            return true;
        }
        return exception.getCause() != null && this.isTransactionRetryException(exception.getCause());
    }
}

