/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.PlanItemDefinitionXmlConverter;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.ScriptServiceTask;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Task;

public class TaskXmlConverter
extends PlanItemDefinitionXmlConverter {
    @Override
    public String getXMLElementName() {
        return "task";
    }

    @Override
    public boolean hasChildElements() {
        return true;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        Task task;
        String type = xtr.getAttributeValue("http://flowable.org/cmmn", "type");
        String className = xtr.getAttributeValue("http://flowable.org/cmmn", "class");
        if (type != null) {
            switch (type) {
                case "java": {
                    ServiceTask serviceTask = new ServiceTask();
                    serviceTask.setType("java");
                    String expression = xtr.getAttributeValue("http://flowable.org/cmmn", "expression");
                    String delegateExpression = xtr.getAttributeValue("http://flowable.org/cmmn", "delegateExpression");
                    if (StringUtils.isNotBlank((CharSequence)className)) {
                        serviceTask.setImplementation(className);
                        serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
                    } else if (StringUtils.isNotBlank((CharSequence)expression)) {
                        serviceTask.setImplementation(expression);
                        serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
                    } else if (StringUtils.isNotBlank((CharSequence)delegateExpression)) {
                        serviceTask.setImplementation(delegateExpression);
                        serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                    }
                    serviceTask.setResultVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "resultVariableName"));
                    task = serviceTask;
                    break;
                }
                case "http": {
                    HttpServiceTask httpServiceTask = new HttpServiceTask();
                    if (StringUtils.isNotBlank((CharSequence)className)) {
                        httpServiceTask.setImplementation(className);
                    }
                    task = httpServiceTask;
                    break;
                }
                case "script": {
                    String autoStoreVariables;
                    String resVarName;
                    ScriptServiceTask scriptTask = new ScriptServiceTask();
                    String scriptFormat = xtr.getAttributeValue("http://flowable.org/cmmn", "scriptFormat");
                    if (StringUtils.isNotBlank((CharSequence)scriptFormat)) {
                        scriptTask.setScriptFormat(scriptFormat.trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)(resVarName = xtr.getAttributeValue("http://flowable.org/cmmn", "resultVariableName")))) {
                        scriptTask.setResultVariableName(resVarName.trim());
                    }
                    if (StringUtils.isNotBlank((CharSequence)(autoStoreVariables = xtr.getAttributeValue("http://flowable.org/cmmn", "autoStoreVariables")))) {
                        scriptTask.setAutoStoreVariables(Boolean.valueOf(autoStoreVariables).booleanValue());
                    }
                    task = scriptTask;
                    break;
                }
                default: {
                    task = new Task();
                    break;
                }
            }
        } else {
            task = new Task();
        }
        this.convertCommonTaskAttributes(xtr, task);
        return task;
    }

    protected void convertCommonTaskAttributes(XMLStreamReader xtr, Task task) {
        String isExclusiveString;
        String isAsyncString;
        String isBlockingExpressionString;
        task.setName(xtr.getAttributeValue(null, "name"));
        String isBlockingString = xtr.getAttributeValue(null, "isBlocking");
        if (StringUtils.isNotEmpty((CharSequence)isBlockingString)) {
            task.setBlocking(Boolean.valueOf(isBlockingString).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(isBlockingExpressionString = xtr.getAttributeValue("http://flowable.org/cmmn", "isBlockingExpression")))) {
            task.setBlockingExpression(isBlockingExpressionString);
        }
        if (StringUtils.isNotEmpty((CharSequence)(isAsyncString = xtr.getAttributeValue("http://flowable.org/cmmn", "async")))) {
            task.setAsync(Boolean.valueOf(isAsyncString.toLowerCase()).booleanValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(isExclusiveString = xtr.getAttributeValue("http://flowable.org/cmmn", "exclusive")))) {
            task.setExclusive(Boolean.valueOf(isExclusiveString).booleanValue());
        }
    }
}

