/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.parser;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.firebirdsql.jdbc.parser.CharSequenceComparison;
import org.firebirdsql.jdbc.parser.LocalStatementType;
import org.firebirdsql.jdbc.parser.OperatorToken;
import org.firebirdsql.jdbc.parser.ReservedToken;
import org.firebirdsql.jdbc.parser.ReturningClauseDetector;
import org.firebirdsql.jdbc.parser.StatementIdentification;
import org.firebirdsql.jdbc.parser.Token;
import org.firebirdsql.jdbc.parser.TokenVisitor;
import org.firebirdsql.jdbc.parser.VisitorRegistrar;

public final class StatementDetector
implements TokenVisitor {
    private static final Map<CharSequence, ParserState> NEXT_AFTER_START;
    private final boolean detectReturning;
    private LocalStatementType statementType = LocalStatementType.UNKNOWN;
    private ParserState parserState = ParserState.START;
    private Token tableNameToken;
    private ReturningClauseDetector returningClauseDetector;

    public StatementDetector() {
        this(true);
    }

    public StatementDetector(boolean detectReturning) {
        this.detectReturning = detectReturning;
    }

    @Override
    public void visitToken(Token token, VisitorRegistrar visitorRegistrar) {
        this.parserState = this.parserState.next(token, this);
        if (this.parserState.isFinalState()) {
            visitorRegistrar.removeVisitor(this);
        } else if (this.parserState == ParserState.FIND_RETURNING) {
            visitorRegistrar.removeVisitor(this);
            if (this.detectReturning) {
                this.returningClauseDetector = new ReturningClauseDetector();
                visitorRegistrar.addVisitor(this.returningClauseDetector);
                this.returningClauseDetector.visitToken(token, visitorRegistrar);
            }
        }
    }

    @Override
    public void complete(VisitorRegistrar visitorRegistrar) {
    }

    public StatementIdentification toStatementIdentification() {
        return new StatementIdentification(this.statementType, this.tableNameToken != null ? this.tableNameToken.text() : null, this.returningClauseDetected());
    }

    boolean returningClauseDetected() {
        return this.returningClauseDetector != null && this.returningClauseDetector.returningClauseDetected();
    }

    public LocalStatementType getStatementType() {
        return this.statementType;
    }

    Token getTableNameToken() {
        return this.tableNameToken;
    }

    private void updateStatementType(LocalStatementType statementType) {
        this.statementType = statementType;
        if (statementType == LocalStatementType.OTHER) {
            this.setTableNameToken(null);
        }
    }

    private void setTableNameToken(Token tableNameToken) {
        this.tableNameToken = tableNameToken;
    }

    static {
        TreeMap<CharSequence, ParserState> nextAfterStart = new TreeMap<CharSequence, ParserState>(CharSequenceComparison.caseInsensitiveComparator());
        nextAfterStart.put("SELECT", ParserState.SELECT);
        nextAfterStart.put("WITH", ParserState.SELECT);
        nextAfterStart.put("EXECUTE", ParserState.EXECUTE);
        nextAfterStart.put("UPDATE", ParserState.UPDATE);
        nextAfterStart.put("DELETE", ParserState.DELETE);
        nextAfterStart.put("INSERT", ParserState.INSERT);
        nextAfterStart.put("MERGE", ParserState.MERGE);
        NEXT_AFTER_START = Collections.unmodifiableMap(nextAfterStart);
    }

    private static enum ParserState {
        START{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (!(token instanceof ReservedToken)) {
                    detector.updateStatementType(LocalStatementType.OTHER);
                    return OTHER;
                }
                ParserState nextState = NEXT_AFTER_START.get(token.textAsCharSequence());
                if (nextState == null) {
                    nextState = OTHER;
                }
                switch (nextState) {
                    case SELECT: {
                        detector.updateStatementType(LocalStatementType.SELECT);
                        break;
                    }
                    case UPDATE: {
                        detector.updateStatementType(LocalStatementType.UPDATE);
                        break;
                    }
                    case DELETE: {
                        detector.updateStatementType(LocalStatementType.DELETE);
                        break;
                    }
                    case INSERT: {
                        detector.updateStatementType(LocalStatementType.INSERT);
                        break;
                    }
                    case MERGE: {
                        detector.updateStatementType(LocalStatementType.MERGE);
                        break;
                    }
                    default: {
                        detector.updateStatementType(LocalStatementType.OTHER);
                    }
                }
                return nextState;
            }
        }
        ,
        SELECT(true),
        EXECUTE{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("PROCEDURE")) {
                    detector.updateStatementType(LocalStatementType.EXECUTE_PROCEDURE);
                    return EXECUTE_PROCEDURE;
                }
                return OTHER;
            }
        }
        ,
        EXECUTE_PROCEDURE(true),
        UPDATE{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token instanceof OperatorToken && token.equalsIgnoreCase("OR")) {
                    detector.updateStatementType(LocalStatementType.UNKNOWN);
                    return POSSIBLY_UPDATE_OR_INSERT;
                }
                return DML_TARGET.next0(token, detector);
            }
        }
        ,
        POSSIBLY_UPDATE_OR_INSERT{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("INSERT")) {
                    detector.updateStatementType(LocalStatementType.UPDATE_OR_INSERT);
                    return INSERT;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        DELETE{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (!(token instanceof ReservedToken) || !token.equalsIgnoreCase("FROM")) {
                    detector.updateStatementType(LocalStatementType.OTHER);
                    return OTHER;
                }
                return DML_TARGET;
            }
        }
        ,
        DML_TARGET{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    detector.setTableNameToken(token);
                    return DML_POSSIBLE_ALIAS;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        DML_POSSIBLE_ALIAS{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    return FIND_RETURNING;
                }
                if (token instanceof ReservedToken) {
                    if (token.equalsIgnoreCase("AS")) {
                        return DML_ALIAS;
                    }
                    return FIND_RETURNING;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        DML_ALIAS{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    return FIND_RETURNING;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        INSERT{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("INTO")) {
                    return INSERT_INTO;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        INSERT_INTO{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token.isValidIdentifier()) {
                    detector.setTableNameToken(token);
                    return FIND_RETURNING;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        MERGE{

            @Override
            ParserState next0(Token token, StatementDetector detector) {
                if (token instanceof ReservedToken && token.equalsIgnoreCase("INTO")) {
                    return DML_TARGET;
                }
                detector.updateStatementType(LocalStatementType.OTHER);
                return OTHER;
            }
        }
        ,
        FIND_RETURNING,
        OTHER(true);

        private final boolean finalState;

        private ParserState() {
            this(false);
        }

        private ParserState(boolean finalState) {
            this.finalState = finalState;
        }

        final boolean isFinalState() {
            return this.finalState;
        }

        final ParserState next(Token token, StatementDetector detector) {
            if (token.isWhitespaceOrComment()) {
                return this;
            }
            return this.next0(token, detector);
        }

        ParserState next0(Token token, StatementDetector detector) {
            throw new IllegalStateException("State " + this + " is a terminal state and next(..) should not be invoked");
        }
    }
}

