/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.parser;

import java.nio.CharBuffer;
import java.util.Objects;
import org.firebirdsql.jdbc.parser.CharSequenceComparison;
import org.firebirdsql.jdbc.parser.Token;

abstract class AbstractToken
implements Token {
    private final int pos;
    private final CharSequence src;
    private String cachedText;

    AbstractToken(int pos, CharSequence src, int start, int end) {
        this.pos = pos;
        this.src = start == 0 && end == src.length() ? src : CharBuffer.wrap(Objects.requireNonNull(src, "src"), start, end);
    }

    AbstractToken(int pos, CharSequence tokenText) {
        this.pos = pos;
        this.src = tokenText;
    }

    @Override
    public final String text() {
        if (this.cachedText != null) {
            return this.cachedText;
        }
        this.cachedText = this.src.toString();
        return this.cachedText;
    }

    @Override
    public final CharSequence textAsCharSequence() {
        return this.src;
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.src);
    }

    @Override
    public final int position() {
        return this.pos;
    }

    @Override
    public int length() {
        return this.src.length();
    }

    @Override
    public boolean isWhitespaceOrComment() {
        return false;
    }

    @Override
    public boolean isValidIdentifier() {
        return false;
    }

    CharSequence subSequence(int start, int end) {
        return this.src.subSequence(start, end);
    }

    char charAt(int index) {
        return this.src.charAt(index);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{position=" + this.pos + ", tokenText='" + this.text() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractToken that = (AbstractToken)o;
        if (this.pos != that.pos) {
            return false;
        }
        return this.srcCharsEquals(that);
    }

    @Override
    public boolean equalsIgnoreCase(String tokenText) {
        return CharSequenceComparison.equalsIgnoreCase(this.src, tokenText);
    }

    private boolean srcCharsEquals(AbstractToken that) {
        int length = this.src.length();
        if (length != that.src.length()) {
            return false;
        }
        for (int idx = 0; idx < length; ++idx) {
            if (this.src.charAt(idx) == that.src.charAt(idx)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.pos;
        result = 31 * result + this.srcHashCode();
        return result;
    }

    private int srcHashCode() {
        int result = 1;
        int end = this.src.length();
        for (int idx = 0; idx < end; ++idx) {
            result = 31 * result + this.src.charAt(idx);
        }
        return result;
    }
}

