/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;

public class FBClob
implements Clob,
NClob {
    private final FBBlob wrappedBlob;

    public FBClob(FBBlob blob) {
        this.wrappedBlob = blob;
    }

    @Override
    public long length() throws SQLException {
        throw new FBDriverNotCapableException("Cannot determine length for CLOB");
    }

    @Override
    public void truncate(long param1) throws SQLException {
        throw new FBDriverNotCapableException("Method truncate(long) is not supported");
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        String string;
        block10: {
            Reader reader = this.getCharacterStream();
            try {
                int n;
                for (long toSkip = pos - 1L; toSkip > 0L; toSkip -= reader.skip(toSkip)) {
                }
                char[] buffer = new char[Math.min(length, 1024)];
                StringBuilder sb = new StringBuilder(length);
                while (length > 0 && (n = reader.read(buffer, 0, Math.min(length, buffer.length))) != -1) {
                    sb.append(buffer, 0, n);
                    length -= n;
                }
                string = sb.toString();
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FBSQLException(e);
                }
            }
            reader.close();
        }
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        InputStream inputStream = this.wrappedBlob.getBinaryStream();
        String encoding = this.getGdsHelper().getJavaEncoding();
        if (encoding == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(inputStream, encoding);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.wrappedBlob.getBinaryStream();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(String, long) is not supported");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Clob, long) is not supported");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(1L, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        int n;
        block8: {
            Writer charStream = this.setCharacterStream(pos);
            try {
                charStream.write(str, offset, len);
                n = len;
                if (charStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (charStream != null) {
                        try {
                            charStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SQLException("IOException writing string to blob", e);
                }
            }
            charStream.close();
        }
        return n;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return this.wrappedBlob.setBinaryStream(pos);
    }

    @Override
    public Writer setCharacterStream(long position) throws SQLException {
        OutputStream outputStream = this.wrappedBlob.setBinaryStream(position);
        String encoding = this.getGdsHelper().getJavaEncoding();
        if (encoding == null) {
            return new OutputStreamWriter(outputStream);
        }
        try {
            return new OutputStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    @Override
    public void free() throws SQLException {
        this.wrappedBlob.free();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        InputStream inputStream = this.wrappedBlob.getBinaryStream(pos, length);
        String encoding = this.getGdsHelper().getJavaEncoding();
        if (encoding == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(inputStream, encoding);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader characterStream, long length) throws SQLException {
        if (length == -1L) {
            this.copyCharacterStream(characterStream);
            return;
        }
        try (Writer writer = this.setCharacterStream(1L);){
            int chunk;
            char[] buffer = new char[1024];
            while (length > 0L && (chunk = characterStream.read(buffer)) != -1) {
                writer.write(buffer, 0, chunk);
                length -= (long)chunk;
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    public void copyCharacterStream(Reader characterStream) throws SQLException {
        try (Writer writer = this.setCharacterStream(1L);){
            int chunk;
            char[] buffer = new char[1024];
            while ((chunk = characterStream.read(buffer)) != -1) {
                writer.write(buffer, 0, chunk);
            }
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    public FBBlob getWrappedBlob() throws SQLException {
        return this.wrappedBlob;
    }

    private GDSHelper getGdsHelper() throws SQLException {
        GDSHelper gdsHelper = this.wrappedBlob.getGdsHelper();
        if (gdsHelper == null) {
            throw FbExceptionBuilder.forException(337248295).toFlatSQLException();
        }
        return gdsHelper;
    }
}

