/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.resources;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;

@Provider
public class RuntimeExceptionMapper
implements ExceptionMapper<RuntimeException> {
    private static final String CONTENT_TYPE = "text/plain";

    public Response toResponse(RuntimeException rex) {
        return Response.status((Response.Status)this.getStatus(rex)).entity((Object)rex.getMessage()).type(CONTENT_TYPE).build();
    }

    public Response.Status getStatus(RuntimeException rex) {
        if (rex instanceof FeatureNotFoundException || rex instanceof GroupNotFoundException) {
            return Response.Status.NOT_FOUND;
        }
        if (rex instanceof FeatureAlreadyExistException) {
            return Response.Status.CONFLICT;
        }
        if (rex instanceof FeatureAccessException) {
            return Response.Status.SERVICE_UNAVAILABLE;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

