/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.resources;

import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.ff4j.core.FeatureStore;
import org.ff4j.web.api.FF4jWebConstants;
import org.ff4j.web.resources.GroupResource;

public class GroupsResource
implements FF4jWebConstants {
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;
    private FeatureStore store = null;

    public GroupsResource() {
    }

    public GroupsResource(UriInfo uriInfo, Request request, FeatureStore store) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.store = store;
    }

    @GET
    @Produces(value={"application/json"})
    public Response readAll() {
        Set setOfGroup = this.getStore().readAllGroups();
        StringBuilder sb = new StringBuilder(" {");
        boolean first = true;
        for (String group : setOfGroup) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + group + "\":\"" + this.uriInfo.getAbsolutePath() + group + "\"");
        }
        sb.append("}");
        return Response.ok((Object)sb.toString()).build();
    }

    @Path(value="{groupName}")
    public GroupResource getGroup(@PathParam(value="groupName") String groupName) {
        return new GroupResource(this.uriInfo, this.request, this.store, groupName);
    }

    public FeatureStore getStore() {
        return this.store;
    }
}

