/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.utils.FeatureJsonMarshaller;
import org.ff4j.web.api.FF4jWebConstants;

public class FeatureResource
implements FF4jWebConstants {
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;
    @Context
    private FeatureStore store;
    private String id;

    public FeatureResource() {
    }

    public FeatureResource(UriInfo uriInfo, Request request, String id, FeatureStore pstore) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.id = id;
        this.store = pstore;
    }

    @GET
    public Response read() {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        return Response.ok((Object)FeatureJsonMarshaller.marshallFeature((Feature)this.getStore().read(this.id))).build();
    }

    @PUT
    public Response upsertFeature(@Context HttpHeaders headers, byte[] data) {
        Feature feat = FeatureJsonMarshaller.unMarshallFeature((String)new String(data));
        if (!this.getStore().exist(feat.getUid())) {
            this.getStore().create(feat);
            String location = String.format("%s/%s", this.uriInfo.getAbsolutePath().toString(), this.id);
            return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)location).entity((Object)this.id).build();
        }
        this.getStore().update(feat);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    public Response deleteFeature() {
        if (this.id == null || "".equals(this.id)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid URL : Must be '/features/{id}' with {id} not null nor empty").build();
        }
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        this.getStore().delete(this.id);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Path(value="enable")
    public Response operationEnable() {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        this.getStore().enable(this.id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="disable")
    public Response operationDisable() {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        this.getStore().disable(this.id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="grantrole")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response operationGrantRole(MultivaluedMap<String, String> formParams) {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        if (!formParams.containsKey((Object)"rolename")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"rolename is a required POST parameter").build();
        }
        String roleName = (String)formParams.getFirst((Object)"rolename");
        this.getStore().grantRoleOnFeature(this.id, roleName);
        return Response.noContent().build();
    }

    @POST
    @Path(value="removerole")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response operationRemoveRole(MultivaluedMap<String, String> formParams) {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        if (!formParams.containsKey((Object)"rolename")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"rolename is a required POST parameter").build();
        }
        String roleName = (String)formParams.getFirst((Object)"rolename");
        this.getStore().removeRoleFromFeature(this.id, roleName);
        return Response.noContent().build();
    }

    @POST
    @Path(value="addGroup")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response operationAddGroup(MultivaluedMap<String, String> formParams) {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        if (!formParams.containsKey((Object)"groupName")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"groupName is a required POST parameter").build();
        }
        String groupName = (String)formParams.getFirst((Object)"groupName");
        this.getStore().addToGroup(this.id, groupName);
        return Response.noContent().build();
    }

    @POST
    @Path(value="removeGroup")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response operationRemoveGroup(MultivaluedMap<String, String> formParams) {
        if (!this.getStore().exist(this.id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(this.id).getMessage()).build();
        }
        if (!formParams.containsKey((Object)"groupName")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"groupName is a required POST parameter").build();
        }
        String groupName = (String)formParams.getFirst((Object)"groupName");
        this.getStore().removeFromGroup(this.id, groupName);
        return Response.noContent().build();
    }

    public FeatureStore getStore() {
        return this.store;
    }
}

