/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.redis.RedisConnection;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;
import redis.clients.jedis.Jedis;

public class PropertyStoreRedis
extends AbstractPropertyStore {
    private RedisConnection redisConnection;

    public PropertyStoreRedis() {
        this(new RedisConnection());
    }

    public PropertyStoreRedis(RedisConnection pRedisConnection) {
        this.redisConnection = pRedisConnection;
    }

    public PropertyStoreRedis(String xmlFeaturesfFile) {
        this();
        this.importPropertiesFromXmlFile(xmlFeaturesfFile);
    }

    public PropertyStoreRedis(String host, int port) {
        this(new RedisConnection(host, port));
    }

    public PropertyStoreRedis(String host, int port, String password, String xmlFeaturesfFile) {
        this(new RedisConnection(host, port, password));
        this.importPropertiesFromXmlFile(xmlFeaturesfFile);
    }

    public PropertyStoreRedis(String host, int port, String xmlFeaturesfFile) {
        this(host, port);
        this.importPropertiesFromXmlFile(xmlFeaturesfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existProperty(String name) {
        Util.assertParamHasLength((String)name, (String)"PropertyName identifier");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.exists("FF4J_PROPERTY_" + name);
            return bl;
        }
    }

    public <T> void createProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.set("FF4J_PROPERTY_" + prop.getName(), prop.toJson());
            jedis.persist("FF4J_PROPERTY_" + prop.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Property property = PropertyJsonParser.parseProperty((String)jedis.get("FF4J_PROPERTY_" + name));
            return property;
        }
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.del("FF4J_PROPERTY_" + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.keys("FF4J_PROPERTY_*");
            if (myKeys != null) {
                for (String key : myKeys) {
                    key = key.replaceAll("FF4J_PROPERTY_", "");
                    mapP.put(key, this.readProperty(key));
                }
            }
            LinkedHashMap<String, Property<?>> linkedHashMap = mapP;
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listPropertyNames() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set propertyNames = jedis.keys("FF4J_PROPERTY_*");
            HashSet<String> responses = new HashSet<String>();
            if (propertyNames != null) {
                for (String pName : propertyNames) {
                    responses.add(pName.replaceAll("FF4J_PROPERTY_", ""));
                }
            }
            HashSet<String> hashSet = responses;
            return hashSet;
        }
    }

    public void clear() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.keys("FF4J_PROPERTY_*");
            jedis.del(myKeys.toArray(new String[0]));
        }
    }

    public RedisConnection getRedisConnection() {
        return this.redisConnection;
    }

    public void setRedisConnection(RedisConnection redisConnection) {
        this.redisConnection = redisConnection;
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }
}

