/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.redis.RedisConnection;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import redis.clients.jedis.Jedis;

public class FeatureStoreRedis
extends AbstractFeatureStore {
    private RedisConnection redisConnection;

    public FeatureStoreRedis() {
        this(new RedisConnection());
    }

    public FeatureStoreRedis(RedisConnection pRedisConnection) {
        this.redisConnection = pRedisConnection;
    }

    public FeatureStoreRedis(String xmlFeaturesfFile) {
        this();
        this.importFeaturesFromXmlFile(xmlFeaturesfFile);
    }

    public FeatureStoreRedis(String host, int port) {
        this(new RedisConnection(host, port));
    }

    public FeatureStoreRedis(String host, int port, String password, String xmlFeaturesfFile) {
        this(new RedisConnection(host, port, password));
        this.importFeaturesFromXmlFile(xmlFeaturesfFile);
    }

    public FeatureStoreRedis(String host, int port, String xmlFeaturesfFile) {
        this(host, port);
        this.importFeaturesFromXmlFile(xmlFeaturesfFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String uid) {
        Util.assertParamHasLength((String)uid, (String)"Feature identifier");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.exists("FF4J_FEATURE_" + uid);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Feature feature = FeatureJsonParser.parseFeature((String)jedis.get("FF4J_FEATURE_" + uid));
            return feature;
        }
    }

    public void update(Feature fp) {
        Util.assertNotNull((String)"Feature", (Object[])new Object[]{fp});
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.set("FF4J_FEATURE_" + fp.getUid(), fp.toJson());
            jedis.persist("FF4J_FEATURE_" + fp.getUid());
        }
    }

    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    public void create(Feature fp) {
        Util.assertNotNull((String)"Feature", (Object[])new Object[]{fp});
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.set("FF4J_FEATURE_" + fp.getUid(), fp.toJson());
            jedis.persist("FF4J_FEATURE_" + fp.getUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Feature> readAll() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.keys("FF4J_FEATURE_*");
            HashMap<String, Feature> myMap = new HashMap<String, Feature>();
            if (myKeys != null) {
                for (String key : myKeys) {
                    key = key.replaceAll("FF4J_FEATURE_", "");
                    myMap.put(key, this.read(key));
                }
            }
            HashMap<String, Feature> hashMap = myMap;
            return hashMap;
        }
    }

    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.del("FF4J_FEATURE_" + fpId);
        }
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    public boolean existGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        return !group.isEmpty();
    }

    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().enable();
            this.update(uid.getValue());
        }
    }

    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().disable();
            this.update(uid.getValue());
        }
    }

    public void addToGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            groups.add(uid.getValue().getGroup());
        }
        groups.remove(null);
        return groups;
    }

    public void clear() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.keys("FF4J_FEATURE_*");
            jedis.del(myKeys.toArray(new String[0]));
        }
    }

    public RedisConnection getRedisConnection() {
        return this.redisConnection;
    }

    public void setRedisConnection(RedisConnection redisConnection) {
        this.redisConnection = redisConnection;
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }
}

