/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.redis.RedisConnection;
import redis.clients.jedis.Jedis;

public class EventRepositoryRedis
extends AbstractEventRepository {
    private RedisConnection redisConnection;
    private static final SimpleDateFormat SDF_KEY = new SimpleDateFormat("yyyyMMdd_HHmm");

    public EventRepositoryRedis() {
        this(new RedisConnection());
    }

    public EventRepositoryRedis(RedisConnection pRedisConnection) {
        this.redisConnection = pRedisConnection;
    }

    public EventRepositoryRedis(String host, int port) {
        this(new RedisConnection(host, port));
    }

    public EventRepositoryRedis(String host, int port, String password) {
        this(new RedisConnection(host, port, password));
    }

    public void createSchema() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEvent(Event evt) {
        if (evt == null) {
            throw new IllegalArgumentException("Event cannot be null nor empty");
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String uid = "FF4J_EVENT_";
            uid = "checkOn".equalsIgnoreCase(evt.getAction()) ? uid + evt.getName() : uid + "AUDITRAIL_";
            uid = uid + "_" + SDF_KEY.format(new Date(evt.getTimestamp()));
            jedis.lpush(uid, new String[]{evt.toJson()});
            jedis.persist(uid);
            boolean bl = true;
            return bl;
        }
    }

    public Event getEventByUUID(String uuid, Long timestamp) {
        return null;
    }

    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return null;
    }

    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit tu) {
        return null;
    }

    public EventSeries searchFeatureUsageEvents(EventQueryDefinition query) {
        return null;
    }

    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return null;
    }

    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return null;
    }

    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return null;
    }

    public EventSeries getAuditTrail(EventQueryDefinition query) {
        return null;
    }

    public void purgeAuditTrail(EventQueryDefinition query) {
    }

    public void purgeFeatureUsage(EventQueryDefinition query) {
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }
}

