/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.GroupMember;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.UserJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupMemberJSONImpl
extends UserJSONImpl
implements GroupMember,
Serializable {
    private static final long serialVersionUID = 8912198140971501463L;
    private Boolean isAdministrator;

    GroupMemberJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    GroupMemberJSONImpl(JSONObject json) throws FacebookException {
        super(json);
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.isAdministrator = z_F4JInternalParseUtil.getBoolean("administrator", json);
    }

    @Override
    public Boolean isAdministrator() {
        return this.isAdministrator;
    }

    static ResponseList<GroupMember> createGroupMemberList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<GroupMember> members = new ResponseListImpl<GroupMember>(size, json, new GroupMember[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject groupMemberJSONObject = list.getJSONObject(i);
                GroupMemberJSONImpl member = new GroupMemberJSONImpl(groupMemberJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(member, groupMemberJSONObject);
                }
                members.add(member);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(members, list);
            }
            return members;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "GroupMemberJSONImpl{isAdministrator=" + this.isAdministrator + '}' + " extends " + super.toString();
    }
}

