/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CommentJSONImpl
extends FacebookResponseImpl
implements Comment,
Serializable {
    private static final long serialVersionUID = 4049049358890693823L;
    private String id;
    private Category from;
    private String message;
    private Boolean canRemove;
    private Date createdTime;
    private Integer likeCount;
    private Boolean isUserLikes;

    CommentJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    CommentJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new CategoryJSONImpl(fromJSONObject);
            } else {
                this.from = null;
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            this.canRemove = z_F4JInternalParseUtil.getBoolean("can_remove", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.likeCount = z_F4JInternalParseUtil.getInt("like_count", json);
            this.isUserLikes = z_F4JInternalParseUtil.getBoolean("user_likes", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Boolean canRemove() {
        return this.canRemove;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Integer getLikeCount() {
        return this.likeCount;
    }

    @Override
    public Boolean isUserLikes() {
        return this.isUserLikes;
    }

    static ResponseList<Comment> createCommentList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Comment> comments = new ResponseListImpl<Comment>(size, json, new Comment[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject commentJSONObject = list.getJSONObject(i);
                CommentJSONImpl comment = new CommentJSONImpl(commentJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(comment, commentJSONObject);
                }
                comments.add(comment);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(comments, list);
            }
            return comments;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommentJSONImpl other = (CommentJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "CommentJSONImpl [id=" + this.id + ", from=" + this.from + ", message=" + this.message + ", canRemove=" + this.canRemove + ", createdTime=" + this.createdTime + ", likeCount=" + this.likeCount + ", isUserLinks=" + this.isUserLikes + "]";
    }
}

