/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.internal.logging.Logger;
import facebook4j.management.APIStatistics;
import facebook4j.management.APIStatisticsMBean;
import facebook4j.management.APIStatisticsOpenMBean;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class FacebookAPIMonitor {
    private static final Logger logger = Logger.getLogger(FacebookAPIMonitor.class);
    private static final FacebookAPIMonitor SINGLETON = new FacebookAPIMonitor();
    private static final APIStatistics STATISTICS = new APIStatistics(100);

    private FacebookAPIMonitor() {
    }

    public static FacebookAPIMonitor getInstance() {
        return SINGLETON;
    }

    public APIStatisticsMBean getStatistics() {
        return STATISTICS;
    }

    void methodCalled(String facebookUrl, long elapsedTime, boolean success) {
        try {
            URL url = new URL(facebookUrl);
            String method = url.getPath();
            STATISTICS.methodCalled(method, elapsedTime, success);
        }
        catch (MalformedURLException ignore) {
            // empty catch block
        }
    }

    static {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName oName = new ObjectName("facebook4j.mbean:type=APIStatisticsOpenMBean");
            APIStatisticsOpenMBean openMBean = new APIStatisticsOpenMBean(STATISTICS);
            mbs.registerMBean(openMBean, oName);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }
}

