/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.beans;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.exparity.beans.ImmutableTypeProperty;
import org.exparity.beans.Type;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheSameAs<T>
extends TypeSafeDiagnosingMatcher<T> {
    private static final String[] DEFAULT_EXCLUDED_PROPERTIES = new String[]{"class", "Class"};
    private static final Logger LOG = LoggerFactory.getLogger(TheSameAs.class);
    private static Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return CompareToBuilder.reflectionCompare((Object)o1, (Object)o2);
        }
    };
    private final Map<String, PropertyComparator> paths = new HashMap<String, PropertyComparator>();
    private final Map<String, PropertyComparator> properties = new HashMap<String, PropertyComparator>();
    private final Map<Class<?>, PropertyComparator> types = new HashMap();
    private final Set<String> excludedPaths = new HashSet<String>();
    private final Set<String> excludedProperties = new HashSet<String>(Arrays.asList(DEFAULT_EXCLUDED_PROPERTIES));
    private final T object;

    public TheSameAs(T object) {
        this.object = object;
    }

    public TheSameAs<T> excludePath(String path) {
        this.excludedPaths.add(path);
        return this;
    }

    public TheSameAs<T> excludeProperty(String property) {
        this.excludedProperties.add(property);
        return this;
    }

    public TheSameAs<T> withPathComparator(String path, PropertyComparator comparator) {
        this.paths.put(path, comparator);
        return this;
    }

    public TheSameAs<T> withPropertyComparator(String path, PropertyComparator comparator) {
        this.properties.put(path, comparator);
        return this;
    }

    public TheSameAs<T> withTypeComparator(Class<?> type, PropertyComparator comparator) {
        this.types.put(type, comparator);
        return this;
    }

    protected boolean matchesSafely(T item, Description mismatchDesc) {
        MismatchContext context = new MismatchContext(mismatchDesc);
        this.compareObjects(this.object, item, "", context);
        return context.areSame();
    }

    public void describeTo(Description description) {
        description.appendText("the same as ").appendValue(this.object);
    }

    private void compareObjects(Object expected, Object actual, String path, MismatchContext ctx) {
        String propertyName;
        LOG.trace("Compare [{}] vs [{}] at [{}]", new Object[]{expected, actual, path});
        String pathNoIndexes = path.replaceAll("\\[\\w*\\]\\.", ".");
        if (this.excludedPaths.contains(pathNoIndexes)) {
            LOG.trace("Ignore path [{}]", (Object)pathNoIndexes);
            return;
        }
        String string = propertyName = StringUtils.contains((String)path, (String)".") ? StringUtils.substringAfterLast((String)pathNoIndexes, (String)".") : pathNoIndexes;
        if (this.excludedProperties.contains(propertyName)) {
            LOG.trace("Ignore property [{}]", (Object)propertyName);
            return;
        }
        if (expected == null) {
            if (actual != null) {
                ctx.addMismatch(expected, actual, path);
            }
            return;
        }
        if (actual == null) {
            ctx.addMismatch(expected, actual, path);
            return;
        }
        if (ctx.hasComparedPair(expected, actual)) {
            LOG.trace("Already compared [{}] vs [{}]", expected, actual);
            return;
        }
        ctx.addComparedPair(expected, actual);
        LOG.trace("Check override for path [{}]", (Object)pathNoIndexes);
        for (Map.Entry<String, PropertyComparator> entry : this.paths.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((String)entry.getKey(), (String)pathNoIndexes)) continue;
            this.compareUsingPropertyCompartor(expected, actual, path, entry.getValue(), ctx);
            return;
        }
        LOG.trace("Check override for property [{}]", (Object)propertyName);
        PropertyComparator comparator = this.getPropertyComparator(propertyName);
        if (comparator != null) {
            this.compareUsingPropertyCompartor(expected, actual, path, comparator, ctx);
            return;
        }
        Class<?> klass = expected.getClass();
        LOG.trace("Check override for type [{}]", klass);
        for (Map.Entry<Class<?>, PropertyComparator> entry : this.types.entrySet()) {
            if (!entry.getKey().equals(klass)) continue;
            this.compareUsingPropertyCompartor(expected, actual, path, entry.getValue(), ctx);
            return;
        }
        Type type = Type.type(klass);
        if (type.isArray()) {
            this.compareArrays(expected, actual, path, ctx);
        } else if (type.is(String.class)) {
            this.compareStrings((String)expected, (String)actual, path, ctx);
        } else if (type.packageName().startsWith("java.lang")) {
            this.compareLangTypes(expected, actual, path, ctx);
        } else if (type.is(Date.class)) {
            this.compareDates((Date)expected, (Date)actual, path, ctx);
        } else if (type.is(BigDecimal.class)) {
            this.compareBigDecimals((BigDecimal)expected, (BigDecimal)actual, path, ctx);
        } else if (type.is(List.class)) {
            this.compareLists((List)expected, (List)actual, path, ctx);
        } else if (type.is(Collection.class)) {
            this.compareCollections((Collection)expected, (Collection)actual, path, ctx);
        } else if (type.is(Map.class)) {
            this.compareMaps((Map)expected, (Map)actual, path, ctx);
        } else {
            for (ImmutableTypeProperty property : type.accessorList()) {
                this.compareObjects(property.getValue(expected), property.getValue(actual), path + this.getDotIfRequired(path) + property.getName(), ctx);
            }
        }
    }

    private PropertyComparator getPropertyComparator(String propertyName) {
        for (Map.Entry<String, PropertyComparator> entry : this.properties.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((String)propertyName, (String)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private void compareArrays(Object expected, Object actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as array", (Object)path);
        try {
            int expectedLength = Array.getLength(expected);
            int actualLength = Array.getLength(actual);
            if (expectedLength != actualLength) {
                ctx.addMismatch(expectedLength, actualLength, path + this.getDotIfRequired(path) + "size");
            } else {
                for (int i = 0; i < expectedLength; ++i) {
                    if (Array.get(expected, i).equals(Array.get(actual, i))) continue;
                    ctx.addMismatch(expected, actual, path + this.getDotIfRequired(path));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private void compareLangTypes(Object expected, Object actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as lang type", (Object)path);
        try {
            if (!expected.equals(actual)) {
                ctx.addMismatch(expected, actual, path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private void compareMaps(Map expected, Map actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as map", (Object)path);
        try {
            if (expected.size() != actual.size()) {
                ctx.addMismatch(expected.size(), actual.size(), path + this.getDotIfRequired(path) + "size");
            } else {
                for (Object key : expected.keySet()) {
                    Object expectedValue = expected.get(key);
                    Object actualValue = actual.get(key);
                    if (actualValue == null) {
                        ctx.addMismatch(expectedValue, null, path + "[" + key + "]");
                        continue;
                    }
                    this.compareObjects(expectedValue, actualValue, path + "[" + key + "]", ctx);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private String getDotIfRequired(String path) {
        return StringUtils.isNotBlank((String)path) ? "." : "";
    }

    private void compareCollections(Collection expected, Collection actual, String path, MismatchContext ctx) {
        this.compareLists(new ArrayList(expected), new ArrayList(actual), path, ctx);
    }

    private void compareBigDecimals(BigDecimal expected, BigDecimal actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as decimal", (Object)path);
        try {
            if (expected.compareTo(actual) != 0) {
                ctx.addMismatch(expected, actual, path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private void compareLists(List expected, List actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as list", (Object)path);
        try {
            if (expected.isEmpty() && actual.isEmpty()) {
                return;
            }
            if (expected.size() != actual.size()) {
                ctx.addMismatch(expected.size(), actual.size(), path + this.getDotIfRequired(path) + "size");
            } else {
                ArrayList expectedList = new ArrayList(expected);
                ArrayList actualList = new ArrayList(actual);
                if (expectedList.get(0) instanceof Comparable) {
                    Collections.sort(expectedList);
                    Collections.sort(actualList);
                } else {
                    Collections.sort(expectedList, DEFAULT_COMPARATOR);
                    Collections.sort(actualList, DEFAULT_COMPARATOR);
                }
                int ctr = 0;
                Iterator i = expectedList.iterator();
                Iterator j = actualList.iterator();
                while (i.hasNext()) {
                    this.compareObjects(i.next(), j.next(), path + "[" + ctr++ + "]", ctx);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private void compareDates(Date expected, Date actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as date", (Object)path);
        try {
            if (expected.getTime() != actual.getTime()) {
                ctx.addMismatch(expected, actual, path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private void compareStrings(String expected, String actual, String path, MismatchContext ctx) {
        LOG.trace("Compare path [{}] as string", (Object)path);
        try {
            if (!StringUtils.equals((String)expected, (String)actual)) {
                ctx.addMismatch(expected, actual, path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private void compareUsingPropertyCompartor(Object expected, Object actual, String path, PropertyComparator comparator, MismatchContext ctx) {
        LOG.trace("Compare path [{}] with comparator [{}]", (Object)path, (Object)comparator.getClass().getSimpleName());
        try {
            if (!comparator.isEquals(expected, actual)) {
                ctx.addMismatch(expected, actual, path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error comparing path '" + path + "'. Error '" + e.getMessage() + "'", e);
        }
    }

    private static class MismatchContext {
        private final Set<Pair> compared = new HashSet<Pair>();
        private final Description desc;
        private boolean same = true;

        public MismatchContext(Description desc) {
            this.desc = desc;
        }

        public boolean areSame() {
            return this.same;
        }

        public void addComparedPair(Object lhs, Object rhs) {
            this.compared.add(new Pair(lhs, rhs));
        }

        public void addMismatch(Object expected, Object actual, String path) {
            if (!this.isFirstMismatch()) {
                this.desc.appendText(SystemUtils.LINE_SEPARATOR);
            }
            this.desc.appendText(path).appendText(" is ").appendValue(actual).appendText(" instead of ").appendValue(expected);
            this.same = false;
        }

        private boolean isFirstMismatch() {
            return this.same;
        }

        public boolean hasComparedPair(Object lhs, Object rhs) {
            return this.compared.contains(new Pair(lhs, rhs));
        }
    }

    private static class Pair {
        private final int lhs;
        private final int rhs;

        public Pair(Object lhs, Object rhs) {
            this.lhs = System.identityHashCode(lhs);
            this.rhs = System.identityHashCode(rhs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair rhs = (Pair)o;
            return new EqualsBuilder().append(this.lhs, rhs.lhs).append(this.rhs, rhs.rhs).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(35, 67).append(this.lhs).append(this.rhs).toHashCode();
        }
    }

    public static interface PropertyComparator {
        public boolean isEquals(Object var1, Object var2);
    }
}

