/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.ListCellRenderer;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.SearchIndexListener;
import org.eobjects.datacleaner.lucene.ui.ConfigureSearchIndicesDialog;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCListCellRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.HorizontalLayout;

public class SingleSearchIndexPropertyWidget
extends AbstractPropertyWidget<SearchIndex>
implements SearchIndexListener {
    private final DCComboBox<String> _comboBox;
    private final JButton _removeButton;
    private final JButton _createButton;
    private final JButton _editButton;
    private final SearchIndexCatalog _catalog;
    private final WindowContext _windowContext;
    private final UserPreferences _userPreferences;
    private final List<Listener> _listeners = new ArrayList<Listener>();

    public SingleSearchIndexPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, SearchIndexCatalog catalog, WindowContext windowContext, UserPreferences userPreferences) {
        super(beanJobBuilder, propertyDescriptor);
        this._catalog = catalog;
        this._windowContext = windowContext;
        this._userPreferences = userPreferences;
        Object[] names = catalog.getSearchIndexNames();
        this._comboBox = new DCComboBox(names);
        this._comboBox.setRenderer((ListCellRenderer)new DCListCellRenderer());
        ImageIcon indexIcon = ImageManager.getInstance().getImageIcon("images/search_index.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[]{this.getClass().getClassLoader()});
        this._createButton = new JButton("Create", indexIcon);
        this._createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureSearchIndicesDialog dialog = new ConfigureSearchIndicesDialog(SingleSearchIndexPropertyWidget.this._windowContext, SingleSearchIndexPropertyWidget.this._catalog, SingleSearchIndexPropertyWidget.this._userPreferences, (DCComboBox<String>)SingleSearchIndexPropertyWidget.this._comboBox);
                dialog.open();
            }
        });
        this._editButton = new JButton("Edit", indexIcon);
        this._editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchIndex searchIndex = SingleSearchIndexPropertyWidget.this.getValue();
                if (searchIndex != null) {
                    ConfigureSearchIndicesDialog dialog = new ConfigureSearchIndicesDialog(SingleSearchIndexPropertyWidget.this._windowContext, SingleSearchIndexPropertyWidget.this._catalog, SingleSearchIndexPropertyWidget.this._userPreferences, (DCComboBox<String>)SingleSearchIndexPropertyWidget.this._comboBox, searchIndex);
                    dialog.open();
                }
            }
        });
        this._removeButton = WidgetFactory.createSmallButton((String)"images/actions/remove.png");
        this._removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String indexName = (String)SingleSearchIndexPropertyWidget.this._comboBox.getSelectedItem();
                if (indexName == null) {
                    return;
                }
                SearchIndex index = SingleSearchIndexPropertyWidget.this._catalog.getSearchIndex(indexName);
                if (index == null) {
                    return;
                }
                SingleSearchIndexPropertyWidget.this._catalog.removeSearchIndex(index);
            }
        });
        this._comboBox.addListener((DCComboBox.Listener)new DCComboBox.Listener<String>(){

            public void onItemSelected(String item) {
                boolean itemSelected = item != null;
                SingleSearchIndexPropertyWidget.this._removeButton.setEnabled(itemSelected);
                SingleSearchIndexPropertyWidget.this._editButton.setEnabled(itemSelected);
                SingleSearchIndexPropertyWidget.this.fireValueChanged();
                SearchIndex searchIndex = SingleSearchIndexPropertyWidget.this._catalog.getSearchIndex(item);
                SingleSearchIndexPropertyWidget.this.notifyListeners(searchIndex);
            }
        });
        SearchIndex currentValue = (SearchIndex)this.getCurrentValue();
        if (currentValue != null) {
            this._comboBox.setSelectedItem((Object)currentValue.getName());
        } else {
            this._comboBox.setSelectedItem(null);
            this._editButton.setEnabled(false);
            this._removeButton.setEnabled(false);
        }
        DCPanel panel = new DCPanel();
        panel.setLayout((LayoutManager)new HorizontalLayout());
        panel.add(this._comboBox);
        panel.add(Box.createHorizontalStrut(4));
        panel.add((Component)this._createButton);
        panel.add(Box.createHorizontalStrut(4));
        panel.add((Component)this._editButton);
        panel.add(Box.createHorizontalStrut(4));
        panel.add((Component)this._removeButton);
        this.add((Component)panel);
    }

    public void addListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    private void notifyListeners(SearchIndex item) {
        for (Listener listener : this._listeners) {
            listener.onSearchIndexSelected(item);
        }
    }

    public SearchIndex getValue() {
        String name = (String)this._comboBox.getSelectedItem();
        return this._catalog.getSearchIndex(name);
    }

    protected void setValue(SearchIndex value) {
        if (value == null) {
            return;
        }
        this._comboBox.setSelectedItem((Object)value.getName());
    }

    protected void onPanelAdd() {
        super.onPanelAdd();
        this._catalog.addListener(this);
    }

    protected void onPanelRemove() {
        super.onPanelRemove();
        this._catalog.removeListener(this);
    }

    @Override
    public void onAdd(SearchIndex searchIndex) {
        this._comboBox.addItem((Object)searchIndex.getName());
    }

    @Override
    public void onRemove(SearchIndex searchIndex) {
        this._comboBox.removeItem((Object)searchIndex.getName());
    }

    public static interface Listener {
        public void onSearchIndexSelected(SearchIndex var1);
    }
}

