/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.lucene.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.lucene.SearchIndex;
import org.eobjects.datacleaner.lucene.SearchIndexCatalog;
import org.eobjects.datacleaner.lucene.SearchIndexListener;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.VerticalLayout;

public class MultipleSearchIndicesPropertyWidget
extends AbstractPropertyWidget<SearchIndex[]>
implements SearchIndexListener,
DCCheckBox.Listener<SearchIndex> {
    private final Map<String, DCCheckBox<SearchIndex>> _checkBoxes;
    private final SearchIndexCatalog _catalog;
    private DCPanel _panel;

    public MultipleSearchIndicesPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, SearchIndexCatalog catalog) {
        super(beanJobBuilder, propertyDescriptor);
        String[] searchIndexNames;
        this._catalog = catalog;
        this._panel = new DCPanel();
        this._checkBoxes = new LinkedHashMap<String, DCCheckBox<SearchIndex>>();
        for (String name : searchIndexNames = catalog.getSearchIndexNames()) {
            SearchIndex searchIndex = catalog.getSearchIndex(name);
            this.onAdd(searchIndex);
        }
        catalog.addListener(this);
        SearchIndex[] currentValue = (SearchIndex[])this.getCurrentValue();
        this.setValue(currentValue);
        this._panel.setLayout((LayoutManager)new VerticalLayout());
        this.add((Component)this._panel);
    }

    public SearchIndex[] getValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        Collection<DCCheckBox<SearchIndex>> checkBoxes = this._checkBoxes.values();
        for (DCCheckBox<SearchIndex> checkBox : checkBoxes) {
            if (!checkBox.isSelected()) continue;
            value.add(checkBox.getValue());
        }
        if (value.isEmpty()) {
            return null;
        }
        return value.toArray(new SearchIndex[value.size()]);
    }

    protected void setValue(SearchIndex[] value) {
        if (value == null) {
            value = new SearchIndex[]{};
        }
        Set<Map.Entry<String, DCCheckBox<SearchIndex>>> entrySet = this._checkBoxes.entrySet();
        for (Map.Entry<String, DCCheckBox<SearchIndex>> entry : entrySet) {
            String name = entry.getKey();
            DCCheckBox<SearchIndex> checkBox = entry.getValue();
            boolean selected = false;
            for (SearchIndex searchIndex : value) {
                if (!name.equals(searchIndex.getName())) continue;
                selected = true;
                break;
            }
            checkBox.setSelected(selected);
        }
    }

    protected void onPanelAdd() {
        super.onPanelAdd();
        this._catalog.addListener(this);
    }

    protected void onPanelRemove() {
        super.onPanelRemove();
        this._catalog.removeListener(this);
    }

    @Override
    public void onAdd(SearchIndex searchIndex) {
        String name = searchIndex.getName();
        DCCheckBox checkBox = new DCCheckBox(name, false);
        checkBox.addListener((DCCheckBox.Listener)this);
        checkBox.setValue((Object)searchIndex);
        this._checkBoxes.put(name, (DCCheckBox<SearchIndex>)checkBox);
        this._panel.add((Component)checkBox);
    }

    @Override
    public void onRemove(SearchIndex searchIndex) {
        String name = searchIndex.getName();
        DCCheckBox<SearchIndex> checkBox = this._checkBoxes.remove(name);
        if (checkBox != null) {
            this._panel.remove(checkBox);
        }
    }

    public void onItemSelected(SearchIndex item, boolean selected) {
        this.fireValueChanged();
    }
}

